/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.valueranges;

import com.arcway.lib.java.SetterSuccess;
import de.plans.lib.util.valueranges.DiscreteValue;
import de.plans.lib.util.valueranges.IInteger;
import de.plans.lib.util.valueranges.IValueRangeHelperList;
import de.plans.lib.util.valueranges.Messages;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;

public class ValueRangeHelperDiscrete
implements IValueRangeHelperList {
    private boolean lastCheckWasSuccessful = true;
    private final DiscreteValue[] possibleValues;
    private final IInteger persistentLocation;
    private final Locale locale;

    public ValueRangeHelperDiscrete(DiscreteValue[] discreteValues, IInteger associatedPersistentLocation, Locale locale) {
        assert (discreteValues != null) : "values must not be null";
        this.possibleValues = discreteValues;
        this.persistentLocation = associatedPersistentLocation;
        this.locale = locale;
    }

    @Override
    public boolean check(String valueToCheck) {
        this.lastCheckWasSuccessful = false;
        DiscreteValue[] discreteValueArray = this.possibleValues;
        int n = this.possibleValues.length;
        int n2 = 0;
        while (n2 < n) {
            DiscreteValue element = discreteValueArray[n2];
            if (element.getName(this.locale).equals(valueToCheck)) {
                this.lastCheckWasSuccessful = true;
            }
            ++n2;
        }
        return this.lastCheckWasSuccessful;
    }

    @Override
    public SetterSuccess setPersistentValue(String newValue) {
        int oldValue = this.persistentLocation.getValue();
        int c = 0;
        while (c < this.possibleValues.length) {
            if (this.possibleValues[c].getName(this.locale).equals(newValue)) {
                this.persistentLocation.setValue(c);
                return oldValue != c ? SetterSuccess.VALUE_CHANGED : SetterSuccess.VALUE_DID_NOT_CHANGE;
            }
            ++c;
        }
        return SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED;
    }

    public DiscreteValue parseStringRepresentation(String value) throws ParseException {
        DiscreteValue[] discreteValueArray = this.possibleValues;
        int n = this.possibleValues.length;
        int n2 = 0;
        while (n2 < n) {
            DiscreteValue element = discreteValueArray[n2];
            if (element.getName(this.locale).equals(value)) {
                return element;
            }
            ++n2;
        }
        throw new ParseException("No value found", 0);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.possibleValues[this.persistentLocation.getValue()].getImage();
    }

    @Override
    public String getDisplayFormat() {
        String displayString = this.possibleValues[this.persistentLocation.getValue()].getName(this.locale);
        if (displayString != null) {
            return displayString;
        }
        return "";
    }

    @Override
    public String[] getPossibleValues() {
        String[] possibleStrings = new String[this.possibleValues.length];
        int c = 0;
        while (c < this.possibleValues.length) {
            possibleStrings[c] = this.possibleValues[c].getName(this.locale);
            ++c;
        }
        return possibleStrings;
    }

    public DiscreteValue[] getDiscreteValues() {
        return this.possibleValues;
    }

    @Override
    public String getErrorMessage(String description) {
        if (this.lastCheckWasSuccessful) {
            return "";
        }
        if (description == null) {
            return Messages.getString("ValueRangeHelperDiscrete.ERROR_WITHOUTDESCRIPTION");
        }
        return String.valueOf(Messages.getString("ValueRangeHelperDiscrete.ERROR_PART_I")) + description + Messages.getString("ValueRangeHelperDiscrete.ERROR_PART_II");
    }

    @Override
    public boolean acceptsNewValues() {
        return false;
    }
}

