/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.incrementalsearch;

import de.plans.lib.util.incrementalsearch.ISearchStringGenerator;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashSet;

public class SearchableObject<D> {
    private final D domainItem;
    private SoftReference<String> searchStringRef;

    public SearchableObject(D o) {
        assert (o != null) : "o must not be null";
        this.domainItem = o;
    }

    public static <DT> Collection<DT> getDomainItems(Collection<SearchableObject<DT>> searchableObjects) {
        HashSet<DT> domainItems = new HashSet<DT>(searchableObjects.size() * 2);
        for (SearchableObject<DT> element : searchableObjects) {
            domainItems.add(element.getDomainItem());
        }
        return domainItems;
    }

    public static <DT> Collection<SearchableObject<DT>> createSearchableObjects(Collection<DT> domainItems) {
        HashSet<SearchableObject<DT>> searchableObjects = new HashSet<SearchableObject<DT>>(domainItems.size() * 2);
        for (DT element : domainItems) {
            searchableObjects.add(new SearchableObject<DT>(element));
        }
        return searchableObjects;
    }

    public String getAndCacheSearchStringRepresentation(ISearchStringGenerator<D> searchStringGenerator) {
        String searchString = this.getSearchString();
        if (searchString == null) {
            searchString = searchStringGenerator.getSearchString(this.getDomainItem());
            this.setSearchString(searchString);
        }
        return searchString;
    }

    public SearchableObject(D o, String searchString) {
        this(o);
        super.setSearchString(searchString);
    }

    private String getSearchString() {
        return this.searchStringRef != null ? this.searchStringRef.get() : null;
    }

    public D getDomainItem() {
        return this.domainItem;
    }

    private void setSearchString(String string) {
        this.searchStringRef = new SoftReference<String>(string);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SearchableObject)) {
            return false;
        }
        return ((SearchableObject)o).getDomainItem().equals(this.getDomainItem());
    }

    public int hashCode() {
        return this.getDomainItem().hashCode();
    }
}

