/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.incrementalsearch;

import java.util.regex.Pattern;

public class SearchStringNormalizer {
    private static final String SPACE_PATTERN = "\\s+";
    private static ThreadLocal<Pattern> COMPILED_SPACE_PATTERN = new ThreadLocal<Pattern>(){

        @Override
        protected synchronized Pattern initialValue() {
            return Pattern.compile(SearchStringNormalizer.SPACE_PATTERN);
        }
    };
    private static final String SINGLE_SPACE = " ";

    public static String normalizeString(String string) {
        String normalizedString = string.trim();
        normalizedString = COMPILED_SPACE_PATTERN.get().matcher(normalizedString).replaceAll(SINGLE_SPACE);
        return normalizedString.toLowerCase();
    }
}

