/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.incrementalsearch;

import com.arcway.lib.concurrent.Future;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.incrementalsearch.DeltaPacket;
import de.plans.lib.util.incrementalsearch.ISearchAlgorithm;
import de.plans.lib.util.incrementalsearch.ISearchCallback;
import de.plans.lib.util.incrementalsearch.ISearchHistoryListener;
import de.plans.lib.util.incrementalsearch.ISearchStringGenerator;
import de.plans.lib.util.incrementalsearch.Search;
import de.plans.lib.util.incrementalsearch.SearchProcessorIsDisposedException;
import de.plans.lib.util.incrementalsearch.SearchStringNormalizer;
import de.plans.lib.util.incrementalsearch.SearchableObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class IncrementalSearchProcessor<DT>
implements Runnable {
    private static final String EMPTY_SEARCH_CRITERION = "";
    private static final String THREAD_NAME = "IncrementalSearchProcessor";
    private static final long SEARCH_START_DELAY = 100L;
    private static final int MAX_DELTA_PACKET_SIZE = 200;
    private static final ILogger logger = Logger.getLogger(IncrementalSearchProcessor.class);
    private ISearchAlgorithm searchAlgorithm;
    private ISearchCallback callback;
    private ISearchStringGenerator<DT> searchStringGenerator;
    private Collection<ISearchHistoryListener> searchHistoryListeners;
    private int outdatedSearchesHistorySize;
    private LinkedList<Runnable> asynchronouslyDeliveredRequests;
    private boolean searchProcessorIsDisposed;
    private boolean searchProcessorMainLoopStopped;
    private String storedKeystrokes;
    private long lastKeystrokeUpdate;
    private Search<DT> effectiveSearch;
    private boolean effectiveSearchEverCompleted;
    private LinkedList<Search<DT>> outdatedSearches;
    private ArrayList<String> searchHistory;
    private HashSet<SearchableObject<DT>> cummulatedSearchInput;
    private List<DeltaPacket<DT>> regularSearchInputDeltaPacketArrivalOrder;
    private Set<DeltaPacket<DT>> regularSearchInputDeltaPacketsToBeProcessed;
    private final Runnable stepNOP = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final Runnable stepDisposeSearchProcessor = new Runnable(){

        @Override
        public void run() {
            IncrementalSearchProcessor.this.searchAlgorithm = null;
            IncrementalSearchProcessor.this.callback = null;
            IncrementalSearchProcessor.this.searchStringGenerator = null;
            IncrementalSearchProcessor.this.searchHistoryListeners = null;
            IncrementalSearchProcessor.this.outdatedSearchesHistorySize = 0;
            IncrementalSearchProcessor.this.asynchronouslyDeliveredRequests = null;
            IncrementalSearchProcessor.this.resetSearchInputRelatedStateOfSearchProcessor();
            IncrementalSearchProcessor.this.searchProcessorMainLoopStopped = true;
        }
    };
    private final Runnable stepProcessDeltaPacket = new Runnable(){

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block15: {
                block14: {
                    if (IncrementalSearchProcessor.access$8(IncrementalSearchProcessor.this) == null || IncrementalSearchProcessor.access$8(IncrementalSearchProcessor.this).getUnconsideredSearchInputDeltaPackets().isEmpty()) break block14;
                    this.processNextSearchInputDeltaPacket(IncrementalSearchProcessor.access$8(IncrementalSearchProcessor.this));
                    if (!IncrementalSearchProcessor.access$8(IncrementalSearchProcessor.this).getUnconsideredSearchInputDeltaPackets().isEmpty()) break block15;
                    IncrementalSearchProcessor.access$9(IncrementalSearchProcessor.this, true);
                    if (IncrementalSearchProcessor.$assertionsDisabled || IncrementalSearchProcessor.access$10(IncrementalSearchProcessor.this).size() <= IncrementalSearchProcessor.access$11(IncrementalSearchProcessor.this)) ** GOTO lbl9
                    throw new AssertionError();
lbl-1000:
                    // 1 sources

                    {
                        IncrementalSearchProcessor.access$10(IncrementalSearchProcessor.this).removeLast();
lbl9:
                        // 2 sources

                        ** while (IncrementalSearchProcessor.access$10((IncrementalSearchProcessor)IncrementalSearchProcessor.this).size() >= IncrementalSearchProcessor.access$11((IncrementalSearchProcessor)IncrementalSearchProcessor.this))
                    }
lbl10:
                    // 1 sources

                    IncrementalSearchProcessor.access$12(IncrementalSearchProcessor.this);
                    if (IncrementalSearchProcessor.access$8(IncrementalSearchProcessor.this).getNormalizedQueryString().equals("")) {
                        IncrementalSearchProcessor.access$13(IncrementalSearchProcessor.this).setSearchResult(ISearchCallback.SEARCH_RESULT_ALL);
                    } else {
                        IncrementalSearchProcessor.access$13(IncrementalSearchProcessor.this).setSearchResult(SearchableObject.getDomainItems(IncrementalSearchProcessor.access$8(IncrementalSearchProcessor.this).getSearchResult()));
                    }
                    break block15;
                }
                if (IncrementalSearchProcessor.access$14(IncrementalSearchProcessor.this)) {
                    selectedOutdatedSearch = null;
                    outdatedSearchesIterator = IncrementalSearchProcessor.access$10(IncrementalSearchProcessor.this).listIterator();
                    while (outdatedSearchesIterator.hasNext()) {
                        outdatedSearch = (Search)outdatedSearchesIterator.next();
                        if (outdatedSearch.getUnconsideredSearchInputDeltaPackets().isEmpty() || IncrementalSearchProcessor.access$15(IncrementalSearchProcessor.this).contains(outdatedSearch.getUnconsideredSearchInputDeltaPackets().get(0)) || selectedOutdatedSearch != null && outdatedSearch.getUnconsideredSearchInputDeltaPackets().size() <= selectedOutdatedSearch.getUnconsideredSearchInputDeltaPackets().size()) continue;
                        selectedOutdatedSearch = outdatedSearch;
                    }
                    if (selectedOutdatedSearch == null) {
                        regularDeltaPacketListIterator = IncrementalSearchProcessor.access$16(IncrementalSearchProcessor.this).iterator();
                        while (selectedOutdatedSearch == null && regularDeltaPacketListIterator.hasNext()) {
                            regularDeltaPacket = (DeltaPacket)regularDeltaPacketListIterator.next();
                            outdatedSearchesIterator = IncrementalSearchProcessor.access$10(IncrementalSearchProcessor.this).listIterator();
                            while (selectedOutdatedSearch == null && outdatedSearchesIterator.hasNext()) {
                                outdatedSearch = (Search)outdatedSearchesIterator.next();
                                if (outdatedSearch.getUnconsideredSearchInputDeltaPackets().isEmpty() || regularDeltaPacket != outdatedSearch.getUnconsideredSearchInputDeltaPackets().get(0)) continue;
                                selectedOutdatedSearch = outdatedSearch;
                            }
                            if (selectedOutdatedSearch != null) continue;
                            regularDeltaPacketListIterator.remove();
                            IncrementalSearchProcessor.access$15(IncrementalSearchProcessor.this).remove(regularDeltaPacket);
                        }
                    }
                    if (selectedOutdatedSearch == null) {
                        outdatedSearchesIterator = IncrementalSearchProcessor.access$10(IncrementalSearchProcessor.this).listIterator();
                        while (selectedOutdatedSearch == null && outdatedSearchesIterator.hasNext()) {
                            outdatedSearch = (Search)outdatedSearchesIterator.next();
                            if (outdatedSearch.getUnconsideredSearchInputDeltaPackets().isEmpty()) continue;
                            selectedOutdatedSearch = outdatedSearch;
                        }
                    }
                    this.processNextSearchInputDeltaPacket(selectedOutdatedSearch);
                } else if (!IncrementalSearchProcessor.access$16(IncrementalSearchProcessor.this).isEmpty() || !IncrementalSearchProcessor.access$15(IncrementalSearchProcessor.this).isEmpty()) {
                    IncrementalSearchProcessor.access$16(IncrementalSearchProcessor.this).clear();
                    IncrementalSearchProcessor.access$15(IncrementalSearchProcessor.this).clear();
                } else if (!IncrementalSearchProcessor.$assertionsDisabled) {
                    throw new AssertionError((Object)"stepProcessDeltaPacket called although no processing needed");
                }
            }
        }

        private void processNextSearchInputDeltaPacket(Search<DT> search) {
            if (!$assertionsDisabled && search == null) {
                throw new AssertionError();
            }
            if (search.getPreprocessedQueryString() == null) {
                search.setPreprocessedQueryString(IncrementalSearchProcessor.this.searchAlgorithm.processString(search.getNormalizedQueryString()));
            }
            if (!search.getUnconsideredSearchInputDeltaPackets().isEmpty()) {
                DeltaPacket currentDeltaPacket = search.getUnconsideredSearchInputDeltaPackets().get(0);
                if (search.getNormalizedQueryString().equals(IncrementalSearchProcessor.EMPTY_SEARCH_CRITERION)) {
                    search.getSearchResult().clear();
                } else {
                    Collection dels;
                    Collection mods;
                    Collection adds = currentDeltaPacket.getAdds();
                    if (adds != null) {
                        for (SearchableObject searchableObject : adds) {
                            if (-1 == IncrementalSearchProcessor.this.searchAlgorithm.matchSubstring(searchableObject.getAndCacheSearchStringRepresentation(IncrementalSearchProcessor.this.searchStringGenerator), search.getNormalizedQueryString(), search.getPreprocessedQueryString())) continue;
                            search.getSearchResult().remove(searchableObject);
                            search.getSearchResult().add(searchableObject);
                        }
                    }
                    if ((mods = currentDeltaPacket.getMods()) != null) {
                        for (SearchableObject searchableObject : mods) {
                            if (-1 != IncrementalSearchProcessor.this.searchAlgorithm.matchSubstring(searchableObject.getAndCacheSearchStringRepresentation(IncrementalSearchProcessor.this.searchStringGenerator), search.getNormalizedQueryString(), search.getPreprocessedQueryString())) {
                                search.getSearchResult().remove(searchableObject);
                                search.getSearchResult().add(searchableObject);
                                continue;
                            }
                            search.getSearchResult().remove(searchableObject);
                        }
                    }
                    if ((dels = currentDeltaPacket.getDels()) != null) {
                        search.getSearchResult().removeAll(dels);
                    }
                }
                search.getUnconsideredSearchInputDeltaPackets().remove(currentDeltaPacket);
            }
        }
    };

    public IncrementalSearchProcessor(ISearchCallback callback, String threadName, ISearchStringGenerator<DT> searchStringGenerator, int historySize, ISearchAlgorithm algorithm, int threadPriority) {
        assert (callback != null) : "callback must not be null";
        assert (algorithm != null) : "algorithm must not be null";
        assert (searchStringGenerator != null) : "searchStringGenerator must not be null";
        this.searchAlgorithm = algorithm;
        this.callback = callback;
        this.searchStringGenerator = searchStringGenerator;
        this.searchHistoryListeners = new ArrayList<ISearchHistoryListener>();
        this.outdatedSearchesHistorySize = historySize;
        this.asynchronouslyDeliveredRequests = new LinkedList();
        this.searchProcessorIsDisposed = false;
        this.searchProcessorMainLoopStopped = false;
        this.resetSearchInputRelatedStateOfSearchProcessor();
        Thread t = new Thread((Runnable)this, "IncrementalSearchProcessor -- " + threadName);
        t.setDaemon(true);
        t.setPriority(threadPriority);
        t.start();
    }

    private void resetSearchInputRelatedStateOfSearchProcessor() {
        this.storedKeystrokes = null;
        this.lastKeystrokeUpdate = 0L;
        this.effectiveSearch = null;
        this.effectiveSearchEverCompleted = false;
        this.outdatedSearches = null;
        this.searchHistory = null;
        this.cummulatedSearchInput = null;
        this.regularSearchInputDeltaPacketArrivalOrder = null;
        this.regularSearchInputDeltaPacketsToBeProcessed = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.searchProcessorMainLoopStopped) {
            Runnable nextStep = null;
            IncrementalSearchProcessor incrementalSearchProcessor = this;
            synchronized (incrementalSearchProcessor) {
                if (!this.asynchronouslyDeliveredRequests.isEmpty() && this.asynchronouslyDeliveredRequests.getFirst() == this.stepDisposeSearchProcessor) {
                    nextStep = this.stepDisposeSearchProcessor;
                } else if (!this.asynchronouslyDeliveredRequests.isEmpty()) {
                    nextStep = this.asynchronouslyDeliveredRequests.removeFirst();
                } else if (this.storedKeystrokes != null && this.lastKeystrokeUpdate + 100L < System.currentTimeMillis()) {
                    nextStep = new StepSetupNewSearch(this.storedKeystrokes);
                    this.storedKeystrokes = null;
                } else if (this.effectiveSearch != null && this.effectiveSearch.getUnconsideredSearchInputDeltaPackets() != null && !this.effectiveSearch.getUnconsideredSearchInputDeltaPackets().isEmpty() || this.areThereOudatedSearchesWhichNeedProcessing() || this.regularSearchInputDeltaPacketArrivalOrder != null && !this.regularSearchInputDeltaPacketArrivalOrder.isEmpty() || this.regularSearchInputDeltaPacketsToBeProcessed != null && !this.regularSearchInputDeltaPacketsToBeProcessed.isEmpty()) {
                    nextStep = this.stepProcessDeltaPacket;
                } else {
                    if (this.storedKeystrokes != null) {
                        long remaingWaitTime = this.lastKeystrokeUpdate + 100L - System.currentTimeMillis();
                        if (remaingWaitTime > 0L) {
                            try {
                                this.wait(remaingWaitTime);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    } else {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    nextStep = this.stepNOP;
                }
            }
            try {
                nextStep.run();
            }
            catch (Throwable throwable) {
                logger.error("IncrementalSearchProcessor: An Exception was encountered.", throwable);
            }
        }
    }

    private boolean areThereOudatedSearchesWhichNeedProcessing() {
        boolean processingNeeded = false;
        if (this.outdatedSearches != null) {
            ListIterator it = this.outdatedSearches.listIterator();
            while (!processingNeeded && it.hasNext()) {
                Search outdatedSearch = (Search)it.next();
                if (outdatedSearch.getUnconsideredSearchInputDeltaPackets().isEmpty()) continue;
                processingNeeded = true;
            }
        }
        return processingNeeded;
    }

    private static <DT> LinkedList<DeltaPacket<DT>> splitIntoDeltaPackets(Collection<SearchableObject<DT>> addedSOs, Collection<SearchableObject<DT>> modifiedSOs, Collection<SearchableObject<DT>> deletedSOs) {
        int nrModifiedSOs;
        LinkedList<DeltaPacket<DT>> listOfDeltaPackets = new LinkedList<DeltaPacket<DT>>();
        int nrAddedSOs = addedSOs == null ? 0 : addedSOs.size();
        int n = nrModifiedSOs = modifiedSOs == null ? 0 : modifiedSOs.size();
        if (nrAddedSOs + nrModifiedSOs <= 200) {
            listOfDeltaPackets.add(new DeltaPacket<DT>(addedSOs, modifiedSOs, deletedSOs));
        } else {
            int i;
            if (addedSOs != null) {
                Iterator<SearchableObject<DT>> addedSOsIt = addedSOs.iterator();
                while (addedSOsIt.hasNext()) {
                    ArrayList newDPadds = new ArrayList(200);
                    i = 0;
                    while (i < 200 && addedSOsIt.hasNext()) {
                        newDPadds.add(addedSOsIt.next());
                        ++i;
                    }
                    listOfDeltaPackets.add(new DeltaPacket(newDPadds, null, null));
                }
            }
            if (modifiedSOs != null) {
                Iterator<SearchableObject<DT>> modifiedSOsIt = modifiedSOs.iterator();
                while (modifiedSOsIt.hasNext()) {
                    ArrayList newDPmods = new ArrayList(200);
                    i = 0;
                    while (i < 200 && modifiedSOsIt.hasNext()) {
                        newDPmods.add(modifiedSOsIt.next());
                        ++i;
                    }
                    listOfDeltaPackets.add(new DeltaPacket(null, newDPmods, null));
                }
            }
            if (deletedSOs != null) {
                listOfDeltaPackets.add(new DeltaPacket<DT>(null, null, deletedSOs));
            }
        }
        return listOfDeltaPackets;
    }

    void scheduleDeltaPacketsInAllDeltaLists(List<DeltaPacket<DT>> deltaPacketList) {
        this.effectiveSearch.getUnconsideredSearchInputDeltaPackets().addAll(deltaPacketList);
        ListIterator outdatedSearchesIterator = this.outdatedSearches.listIterator();
        while (outdatedSearchesIterator.hasNext()) {
            Search outdatedSearch = (Search)outdatedSearchesIterator.next();
            outdatedSearch.getUnconsideredSearchInputDeltaPackets().addAll(deltaPacketList);
        }
        this.regularSearchInputDeltaPacketArrivalOrder.addAll(deltaPacketList);
        this.regularSearchInputDeltaPacketsToBeProcessed.addAll(deltaPacketList);
    }

    private void updateSearchHistory() {
        ArrayList<String> oldSearchHistory = this.searchHistory;
        ArrayList<String> newSearchHistory = new ArrayList<String>();
        if (this.effectiveSearch != null && this.effectiveSearchEverCompleted) {
            newSearchHistory.add(this.effectiveSearch.getPlainQueryString());
        }
        if (this.outdatedSearches != null) {
            for (Search search : this.outdatedSearches) {
                newSearchHistory.add(search.getPlainQueryString());
            }
        }
        if (!(oldSearchHistory != null && oldSearchHistory.equals(newSearchHistory) || this.searchHistoryListeners == null)) {
            for (ISearchHistoryListener iSearchHistoryListener : this.searchHistoryListeners) {
                iSearchHistoryListener.searchHistoryChanged(newSearchHistory);
            }
        }
        this.searchHistory = newSearchHistory;
    }

    private synchronized void queueNewRequest(Runnable newRequest) throws SearchProcessorIsDisposedException {
        if (this.searchProcessorIsDisposed) {
            throw new SearchProcessorIsDisposedException();
        }
        this.asynchronouslyDeliveredRequests.add(newRequest);
        this.notifyAll();
    }

    public void setNewSearchInput(Collection<DT> searchInput, List<String> p_queries) throws SearchProcessorIsDisposedException {
        List<Object> queries;
        assert (searchInput != null);
        if (p_queries == null || p_queries.isEmpty()) {
            queries = new ArrayList();
            queries.add(EMPTY_SEARCH_CRITERION);
        } else {
            queries = p_queries;
        }
        StepNewSearchInput newRequest = new StepNewSearchInput(searchInput, queries);
        this.queueNewRequest(newRequest);
    }

    public void updateDeltas(Collection<DT> adds, Collection<DT> mods, Collection<DT> dels) throws SearchProcessorIsDisposedException {
        if (this.searchProcessorIsDisposed) {
            throw new SearchProcessorIsDisposedException();
        }
        if (adds != null && !adds.isEmpty() || mods != null && !mods.isEmpty() || dels != null && !dels.isEmpty()) {
            StepMergeDeliveredDeltaPacket newRequest = new StepMergeDeliveredDeltaPacket(new DeltaPacket<DT>(adds != null ? SearchableObject.createSearchableObjects(adds) : null, mods != null ? SearchableObject.createSearchableObjects(mods) : null, dels != null ? SearchableObject.createSearchableObjects(dels) : null));
            this.queueNewRequest(newRequest);
        }
    }

    public void updateSearchCriterion(String p_keystrokes) throws SearchProcessorIsDisposedException {
        String keystrokes = p_keystrokes == null ? EMPTY_SEARCH_CRITERION : p_keystrokes;
        StepStoreNewKeystrokes newRequest = new StepStoreNewKeystrokes(keystrokes);
        this.queueNewRequest(newRequest);
    }

    public synchronized void dispose() throws SearchProcessorIsDisposedException {
        this.queueNewRequest(this.stepDisposeSearchProcessor);
        this.searchProcessorIsDisposed = true;
    }

    public List<String> getQueryHistory() throws SearchProcessorIsDisposedException {
        final Future future = new Future();
        final List[] resultContainer = new List[1];
        Runnable newRequest = new Runnable(){

            @Override
            public void run() {
                IncrementalSearchProcessor.this.updateSearchHistory();
                resultContainer[0] = IncrementalSearchProcessor.this.searchHistory;
                future.triggerWaitingThreads();
            }
        };
        this.queueNewRequest(newRequest);
        future.waitUntilTriggered();
        return resultContainer[0];
    }

    public void addSearchHistoryListener(ISearchHistoryListener listener) throws SearchProcessorIsDisposedException {
        final ISearchHistoryListener listenerToBeAdded = listener;
        Runnable newRequest = new Runnable(){

            @Override
            public void run() {
                IncrementalSearchProcessor.this.searchHistoryListeners.add(listenerToBeAdded);
            }
        };
        this.queueNewRequest(newRequest);
    }

    public void removeSearchHistoryListener(ISearchHistoryListener listener) throws SearchProcessorIsDisposedException {
        final ISearchHistoryListener listenerToBeRemoved = listener;
        Runnable newRequest = new Runnable(){

            @Override
            public void run() {
                IncrementalSearchProcessor.this.searchHistoryListeners.remove(listenerToBeRemoved);
            }
        };
        this.queueNewRequest(newRequest);
    }

    static /* synthetic */ ISearchCallback access$13(IncrementalSearchProcessor incrementalSearchProcessor) {
        return incrementalSearchProcessor.callback;
    }

    static /* synthetic */ boolean access$14(IncrementalSearchProcessor incrementalSearchProcessor) {
        return incrementalSearchProcessor.areThereOudatedSearchesWhichNeedProcessing();
    }

    static /* synthetic */ Set access$15(IncrementalSearchProcessor incrementalSearchProcessor) {
        return incrementalSearchProcessor.regularSearchInputDeltaPacketsToBeProcessed;
    }

    static /* synthetic */ List access$16(IncrementalSearchProcessor incrementalSearchProcessor) {
        return incrementalSearchProcessor.regularSearchInputDeltaPacketArrivalOrder;
    }

    class StepMergeDeliveredDeltaPacket
    implements Runnable {
        private final DeltaPacket<DT> deliveredDeltaPacket;

        public StepMergeDeliveredDeltaPacket(DeltaPacket<DT> deliveredDeltaPacket) {
            this.deliveredDeltaPacket = deliveredDeltaPacket;
        }

        @Override
        public void run() {
            Collection dels;
            Collection mods;
            assert (this.deliveredDeltaPacket != null);
            Collection adds = this.deliveredDeltaPacket.getAdds();
            if (adds != null) {
                IncrementalSearchProcessor.this.cummulatedSearchInput.removeAll(adds);
                IncrementalSearchProcessor.this.cummulatedSearchInput.addAll(adds);
            }
            if ((mods = this.deliveredDeltaPacket.getMods()) != null) {
                IncrementalSearchProcessor.this.cummulatedSearchInput.removeAll(mods);
                IncrementalSearchProcessor.this.cummulatedSearchInput.addAll(mods);
            }
            if ((dels = this.deliveredDeltaPacket.getDels()) != null) {
                IncrementalSearchProcessor.this.cummulatedSearchInput.removeAll(dels);
            }
            IncrementalSearchProcessor.this.scheduleDeltaPacketsInAllDeltaLists(IncrementalSearchProcessor.splitIntoDeltaPackets(this.deliveredDeltaPacket.getAdds(), this.deliveredDeltaPacket.getMods(), this.deliveredDeltaPacket.getDels()));
        }
    }

    class StepNewSearchInput
    implements Runnable {
        private final Collection<DT> searchInput;
        private final List<String> queries;

        public StepNewSearchInput(Collection<DT> searchInput, List<String> queries) {
            this.searchInput = searchInput;
            this.queries = queries;
        }

        @Override
        public void run() {
            IncrementalSearchProcessor.this.resetSearchInputRelatedStateOfSearchProcessor();
            IncrementalSearchProcessor.this.cummulatedSearchInput = new HashSet();
            IncrementalSearchProcessor.this.cummulatedSearchInput.addAll(SearchableObject.createSearchableObjects(this.searchInput));
            IncrementalSearchProcessor.this.regularSearchInputDeltaPacketArrivalOrder = new ArrayList();
            IncrementalSearchProcessor.this.regularSearchInputDeltaPacketsToBeProcessed = new HashSet();
            Iterator<String> queryIt = this.queries.iterator();
            IncrementalSearchProcessor.this.effectiveSearch = new Search(queryIt.next(), null);
            IncrementalSearchProcessor.this.outdatedSearches = new LinkedList();
            while (queryIt.hasNext()) {
                boolean addSearch = true;
                Search newOutdatedSearch = new Search(queryIt.next(), null);
                if (newOutdatedSearch.getNormalizedQueryString().equals(IncrementalSearchProcessor.this.effectiveSearch.getPlainQueryString())) {
                    addSearch = false;
                }
                for (Search search : IncrementalSearchProcessor.this.outdatedSearches) {
                    if (!search.getNormalizedQueryString().equals(newOutdatedSearch.getNormalizedQueryString())) continue;
                    addSearch = false;
                }
                if (!addSearch) continue;
                IncrementalSearchProcessor.this.outdatedSearches.add(newOutdatedSearch);
            }
            IncrementalSearchProcessor.this.scheduleDeltaPacketsInAllDeltaLists(IncrementalSearchProcessor.splitIntoDeltaPackets(IncrementalSearchProcessor.this.cummulatedSearchInput, null, null));
            IncrementalSearchProcessor.this.updateSearchHistory();
        }
    }

    class StepSetupNewSearch
    implements Runnable {
        private final String newStoredKeystrokes;

        public StepSetupNewSearch(String p_storedKeystrokes) {
            this.newStoredKeystrokes = p_storedKeystrokes;
        }

        @Override
        public void run() {
            String normalizedKeystrokes = SearchStringNormalizer.normalizeString(this.newStoredKeystrokes);
            if (IncrementalSearchProcessor.this.effectiveSearch != null && IncrementalSearchProcessor.this.effectiveSearch.getNormalizedQueryString().equals(normalizedKeystrokes)) {
                IncrementalSearchProcessor.this.effectiveSearch.setPlainQueryString(this.newStoredKeystrokes);
            } else {
                if (IncrementalSearchProcessor.this.effectiveSearchEverCompleted) {
                    while (IncrementalSearchProcessor.this.outdatedSearches.size() >= IncrementalSearchProcessor.this.outdatedSearchesHistorySize) {
                        assert (IncrementalSearchProcessor.this.outdatedSearches.size() < IncrementalSearchProcessor.this.outdatedSearchesHistorySize);
                        IncrementalSearchProcessor.this.outdatedSearches.removeLast();
                    }
                    IncrementalSearchProcessor.this.outdatedSearches.addFirst(IncrementalSearchProcessor.this.effectiveSearch);
                }
                IncrementalSearchProcessor.this.effectiveSearch = null;
                IncrementalSearchProcessor.this.effectiveSearchEverCompleted = false;
                if (IncrementalSearchProcessor.this.effectiveSearch == null) {
                    Iterator outdatedSearchesIt = IncrementalSearchProcessor.this.outdatedSearches.iterator();
                    while (IncrementalSearchProcessor.this.effectiveSearch == null && outdatedSearchesIt.hasNext()) {
                        Search outdatedSearch = (Search)outdatedSearchesIt.next();
                        if (!normalizedKeystrokes.equals(outdatedSearch.getNormalizedQueryString())) continue;
                        IncrementalSearchProcessor.this.effectiveSearch = outdatedSearch;
                        outdatedSearch.setPlainQueryString(this.newStoredKeystrokes);
                        IncrementalSearchProcessor.this.effectiveSearchEverCompleted = true;
                        outdatedSearchesIt.remove();
                    }
                }
                if (IncrementalSearchProcessor.this.effectiveSearch == null) {
                    IncrementalSearchProcessor.this.effectiveSearch = new Search(this.newStoredKeystrokes, null);
                    IncrementalSearchProcessor.this.effectiveSearchEverCompleted = false;
                    int genericSearchIndex = -1;
                    int genericSearchIndexSNeededMatches = 0;
                    int i = IncrementalSearchProcessor.this.outdatedSearches.size() - 1;
                    while (i >= 0) {
                        Search outdatedSearch = (Search)IncrementalSearchProcessor.this.outdatedSearches.get(i);
                        if (normalizedKeystrokes.indexOf(outdatedSearch.getNormalizedQueryString()) != -1) {
                            int outdatedSearchSNeededMatches = outdatedSearch.getNormalizedQueryString().equals(IncrementalSearchProcessor.EMPTY_SEARCH_CRITERION) ? IncrementalSearchProcessor.this.cummulatedSearchInput.size() : outdatedSearch.pendingMatches() + outdatedSearch.getSearchResult().size();
                            if (genericSearchIndex == -1 || genericSearchIndexSNeededMatches > outdatedSearchSNeededMatches) {
                                genericSearchIndex = i;
                                genericSearchIndexSNeededMatches = outdatedSearchSNeededMatches;
                            }
                        }
                        --i;
                    }
                    if (genericSearchIndex == -1 || genericSearchIndex != -1 && ((Search)IncrementalSearchProcessor.this.outdatedSearches.get(genericSearchIndex)).getNormalizedQueryString().equals(IncrementalSearchProcessor.EMPTY_SEARCH_CRITERION)) {
                        IncrementalSearchProcessor.this.effectiveSearch.getUnconsideredSearchInputDeltaPackets().addAll(IncrementalSearchProcessor.splitIntoDeltaPackets(IncrementalSearchProcessor.this.cummulatedSearchInput, null, null));
                    } else {
                        Search outdatedSearch = (Search)IncrementalSearchProcessor.this.outdatedSearches.get(genericSearchIndex);
                        IncrementalSearchProcessor.this.effectiveSearch.getUnconsideredSearchInputDeltaPackets().addAll(IncrementalSearchProcessor.splitIntoDeltaPackets(outdatedSearch.getSearchResult(), null, null));
                        IncrementalSearchProcessor.this.effectiveSearch.getUnconsideredSearchInputDeltaPackets().addAll(outdatedSearch.getUnconsideredSearchInputDeltaPackets());
                    }
                }
                if (IncrementalSearchProcessor.this.effectiveSearch.getUnconsideredSearchInputDeltaPackets().isEmpty()) {
                    IncrementalSearchProcessor.this.effectiveSearch.getUnconsideredSearchInputDeltaPackets().add(new DeltaPacket(null, null, null));
                }
                IncrementalSearchProcessor.this.updateSearchHistory();
            }
        }
    }

    class StepStoreNewKeystrokes
    implements Runnable {
        private final long newKeystrokeDeliveryTime = System.currentTimeMillis();
        private final String newKeystrokes;

        public StepStoreNewKeystrokes(String newKeystrokes) {
            this.newKeystrokes = newKeystrokes;
        }

        @Override
        public void run() {
            IncrementalSearchProcessor.this.storedKeystrokes = this.newKeystrokes;
            IncrementalSearchProcessor.this.lastKeystrokeUpdate = this.newKeystrokeDeliveryTime;
        }
    }
}

