/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class DecoratingLabelProvider
implements ILabelProvider {
    private final List<ILabelDecorator> decorators = new ArrayList<ILabelDecorator>();
    private final ILabelProvider baseLabelProvider;

    public DecoratingLabelProvider(ILabelProvider baseLabelProvider) {
        this.baseLabelProvider = baseLabelProvider;
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        this.decorators.add(decorator);
    }

    public Image getImage(Object element) {
        Image image = this.baseLabelProvider.getImage(element);
        for (ILabelDecorator decorator : this.decorators) {
            image = decorator.decorateImage(image, element);
        }
        return image;
    }

    public String getText(Object element) {
        String text = this.baseLabelProvider.getText(element);
        for (ILabelDecorator decorator : this.decorators) {
            String decorText = decorator.decorateText(text, element);
            if (decorText == null) continue;
            text = decorText;
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
        this.baseLabelProvider.addListener(listener);
    }

    public void dispose() {
        for (ILabelDecorator decorator : this.decorators) {
            decorator.dispose();
        }
        this.baseLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.baseLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.baseLabelProvider.removeListener(listener);
    }
}

