/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.gui;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class DecimalTextVerifier
implements VerifyListener {
    boolean onlyPositiveNumbers = false;
    DecimalFormat decimalFormater = (DecimalFormat)NumberFormat.getInstance();
    int numberOfDecimals = 0;
    static final String MATCH_STRING_CORE = "0123456789";
    String matchString;
    char decimalSymbol;
    Pattern realNumberPattern;

    public DecimalTextVerifier(boolean onlyPositiveNumbers, int numberOfDecimals) {
        this.onlyPositiveNumbers = onlyPositiveNumbers;
        this.decimalSymbol = this.decimalFormater.getDecimalFormatSymbols().getDecimalSeparator();
        this.matchString = MATCH_STRING_CORE + this.decimalSymbol;
        if (!onlyPositiveNumbers) {
            this.matchString = String.valueOf(this.matchString) + "-";
        }
        this.setNumberOfDecimals(numberOfDecimals);
    }

    public void setNumberOfDecimals(int numberOfDecimals) {
        this.numberOfDecimals = numberOfDecimals;
        String pattern = "";
        if (!this.onlyPositiveNumbers) {
            pattern = String.valueOf(pattern) + "-?";
        }
        pattern = String.valueOf(pattern) + "[1-9]*[0-9]*{1}";
        if (numberOfDecimals > 0) {
            pattern = String.valueOf(pattern) + "([" + this.decimalSymbol + "][0-9]*)?";
        }
        this.realNumberPattern = Pattern.compile(pattern);
    }

    public void verifyText(VerifyEvent event) {
        if (event.keyCode == 8 || event.keyCode == 127) {
            event.doit = true;
            return;
        }
        if (event.widget instanceof Text) {
            Text control = (Text)event.widget;
            String text = control.getText();
            event.doit = false;
            String newText = String.valueOf(text.substring(0, event.start)) + event.text + text.substring(event.end);
            if (newText.equals("")) {
                event.doit = true;
                return;
            }
            Matcher matcher = this.realNumberPattern.matcher(newText);
            boolean valid = matcher.matches();
            if (!valid) {
                event.doit = false;
                return;
            }
            try {
                ParsePosition parsePos = new ParsePosition(0);
                Number number = this.decimalFormater.parse(newText, parsePos);
                if (number == null || parsePos.getIndex() < newText.length()) {
                    event.doit = false;
                } else {
                    int pos = newText.indexOf(this.decimalSymbol);
                    if (pos != -1) {
                        event.doit = true;
                        if (newText.indexOf(this.decimalSymbol, pos + 1) != -1) {
                            event.doit = false;
                            return;
                        }
                        if (newText.substring(pos + 1).length() > this.numberOfDecimals) {
                            event.doit = false;
                            return;
                        }
                    }
                    event.doit = true;
                }
            }
            catch (NullPointerException e) {
                event.doit = false;
            }
        }
    }
}

