/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import de.plans.lib.util.NumberVerifyListener;
import org.eclipse.swt.widgets.Text;

public class DoubleVerifyListener
extends NumberVerifyListener {
    private final char[] expoChars = new char[]{'e', 'E'};

    public DoubleVerifyListener(Text text) {
        super(text, false, true);
    }

    @Override
    protected void parseNumber(String numberAsString) throws NumberFormatException {
        double value = Double.parseDouble(numberAsString);
        if (value == Double.POSITIVE_INFINITY || value == Double.NEGATIVE_INFINITY) {
            throw new NumberFormatException("overflow");
        }
    }

    @Override
    protected boolean canInsert(String stringToInsert, int position, String stringBeforeInsertion, String stringAfterInsertion) {
        if (position > 0 && this.containsOnlyOneOf(stringAfterInsertion, this.expoChars) && !this.isFirst(stringAfterInsertion, this.expoChars)) {
            if (this.isAtTheEnd(stringAfterInsertion, this.expoChars) && stringToInsert.indexOf("-", 1) < 0 && stringToInsert.indexOf("+", 1) < 0) {
                return true;
            }
            if (this.isAtTheEnd(stringAfterInsertion, '-') || this.isAtTheEnd(stringAfterInsertion, '+')) {
                return this.isAtTheEnd(stringAfterInsertion.substring(0, stringAfterInsertion.length() - 1), this.expoChars);
            }
        }
        return false;
    }

    private boolean isFirst(String string, char[] characters) {
        char[] cArray = characters;
        int n = characters.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (string.indexOf(element) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isAtTheEnd(String string, char character) {
        return string.indexOf(character) == string.length() - 1;
    }

    private boolean isAtTheEnd(String string, char[] characters) {
        char[] cArray = characters;
        int n = characters.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (this.isAtTheEnd(string, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean containsOnlyOneOf(String string, char[] characters) {
        boolean found = false;
        char[] cArray = characters;
        int n = characters.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            int index = string.indexOf(element);
            if (index > -1) {
                if (found) {
                    found = false;
                    break;
                }
                found = true;
            }
            ++n2;
        }
        return found;
    }
}

