/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.svg;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.Color;
import de.plans.lib.svg.EOSVGG;
import de.plans.lib.svg.EOSVGText;
import de.plans.lib.svg.SVGAbstractConverter;
import de.plans.lib.svg.SVGConvertHelper;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class SVGText
extends SVGAbstractConverter {
    private final String text;
    private final Point point;
    private final Direction direction;
    private final double textLength;
    private final int textAlignment;
    private final Color textColor;
    private final String fontFamiliy;
    private final double textHeight;
    private final boolean isBold;
    private final boolean isItalic;

    public SVGText(String text, Point point, Direction direction, int textAlignment, double textLength, Color textColor, String fontFamiliy, double textHeight, boolean isBold, boolean isItalic) {
        assert (text != null);
        assert (point != null);
        assert (textAlignment == 1 || textAlignment == 2 || textAlignment == 4);
        assert (textColor != null) : "textColor = null";
        assert (fontFamiliy != null);
        assert (textHeight >= -1.0E-10) : "textHeight < null";
        this.text = text;
        this.point = point;
        this.direction = direction;
        this.textAlignment = textAlignment;
        this.textLength = textLength;
        this.textColor = textColor;
        this.fontFamiliy = fontFamiliy;
        this.textHeight = textHeight;
        this.isBold = isBold;
        this.isItalic = isItalic;
    }

    @Override
    public void writeToXML(EncodableObjectBase.WriteContext outputstream, int indention) throws EXEncoderException {
        EOSVGText svgText = new EOSVGText();
        svgText.setTextValue(this.text);
        svgText.setTextLength(this.textLength);
        svgText.setTextAnchor(this.textAlignment);
        svgText.setTextColor(SVGConvertHelper.convertColorToSVGColor(this.textColor));
        svgText.setFontFamily(this.fontFamiliy);
        svgText.setTextHeight(this.textHeight);
        svgText.setFontWeight(this.convertFontWeight());
        svgText.setFontStyle(this.convertFontStyle());
        svgText.setX(this.point.x);
        svgText.setY(this.point.y);
        if (this.direction.equalsDirection(Direction.ANGLE_0)) {
            svgText.writeXMLBody(outputstream, indention);
        } else {
            EOSVGG rotation = new EOSVGG();
            double angleGeo = this.direction.getAngle();
            double angleSVG = Geo.getNormalizedAngle((double)(-angleGeo));
            rotation.setTransform("rotate(" + Double.toString(angleSVG) + "," + Double.toString(this.point.x) + "," + Double.toString(this.point.y) + ")");
            rotation.writeSplittedToXMLOpenElement(outputstream, indention, false);
            svgText.writeXMLBody(outputstream, indention + 1);
            rotation.writeSplittedToXMLCloseElement(outputstream, indention, false);
        }
    }

    private String convertFontWeight() {
        if (this.isBold) {
            return "bold";
        }
        return "normal";
    }

    private String convertFontStyle() {
        if (this.isItalic) {
            return "italic";
        }
        return "normal";
    }
}

