/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.svg;

import com.arcway.lib.geometry.Rectangle;
import de.plans.lib.svg.EOSVGRoot;
import de.plans.lib.svg.SVGAbstractConverter;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class SVGRoot
extends SVGAbstractConverter {
    private EOSVGRoot svgRoot;
    private final double width;
    private final double height;
    private final Rectangle viewBox;
    private final boolean isInPixel;

    public SVGRoot(double width, double height, Rectangle viewBox, boolean isInPixel) {
        this.width = width;
        this.height = height;
        this.viewBox = viewBox;
        this.isInPixel = isInPixel;
    }

    @Override
    public void writeToXML(EncodableObjectBase.WriteContext outputstream, int indention) throws EXEncoderException {
    }

    public void writeToXMLStartTag(EncodableObjectBase.WriteContext writeContext, int indention) throws EXEncoderException {
        this.svgRoot = new EOSVGRoot();
        if (this.isInPixel) {
            this.svgRoot.setHeight((int)Math.ceil(this.height) + "px");
            this.svgRoot.setWidth((int)Math.ceil(this.width) + "px");
        } else {
            this.svgRoot.setHeight(this.height + "mm");
            this.svgRoot.setWidth(this.width + "mm");
        }
        this.svgRoot.setHeight(this.height + "mm");
        this.svgRoot.setWidth(this.width + "mm");
        this.svgRoot.setViewBoxX1(this.viewBox.upperLeft.x);
        this.svgRoot.setViewBoxY1(this.viewBox.upperLeft.y);
        this.svgRoot.setViewBoxX2(this.viewBox.lowerRight.x);
        this.svgRoot.setViewBoxY2(this.viewBox.lowerRight.y);
        this.svgRoot.writeSplittedToXMLOpenElement(writeContext, indention, false);
    }

    public void writeToXMLEndTag(EncodableObjectBase.WriteContext writeContext, int indention) throws EXEncoderException {
        assert (this.svgRoot != null) : "writeToXMLStartTag was not called before";
        this.svgRoot.writeSplittedToXMLCloseElement(writeContext, indention, false);
    }
}

