/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.svg;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.geometry.polygon.PolygonCorner;
import com.arcway.lib.graphics.Color;
import de.plans.lib.svg.EOSVGPath;
import de.plans.lib.svg.SVGAbstractConverter;
import de.plans.lib.svg.SVGConvertHelper;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class SVGPolygon
extends SVGAbstractConverter {
    private final Polygon polygon;
    private final Color fillColor;
    private final int fillAlpha;

    public SVGPolygon(Polygon polygon, Color fillColor, int fillAlpha) {
        assert (polygon != null);
        assert (fillColor != null);
        this.polygon = polygon;
        this.fillColor = fillColor;
        this.fillAlpha = fillAlpha;
    }

    @Override
    public void writeToXML(EncodableObjectBase.WriteContext outputstream, int indention) throws EXEncoderException {
        EOSVGPath path = new EOSVGPath();
        String dValue = "";
        int i = 0;
        while (i < this.polygon.getPolygonCornerPointCount()) {
            int clockDirection;
            Point endPoint;
            Point startPoint;
            PolygonCorner polygonCorner = this.polygon.getPolygonCorner(i);
            if (i == 0) {
                if (polygonCorner.arc != null) {
                    startPoint = polygonCorner.arc.getPointByAngle(polygonCorner.arc.angleStart);
                    endPoint = polygonCorner.arc.getPointByAngle(polygonCorner.arc.angleEnd);
                    clockDirection = polygonCorner.arc.getDirection() ? 1 : 0;
                    dValue = String.valueOf(dValue) + "M " + startPoint.x + "," + startPoint.y + " A " + polygonCorner.arc.rx + " " + polygonCorner.arc.ry + " 0 0 " + clockDirection + " " + endPoint.x + "," + endPoint.y;
                } else {
                    dValue = String.valueOf(dValue) + " M " + polygonCorner.x + "," + polygonCorner.y;
                }
            } else if (polygonCorner.arc != null) {
                clockDirection = polygonCorner.arc.getDirection() ? 1 : 0;
                startPoint = polygonCorner.arc.getPointByAngle(polygonCorner.arc.angleStart);
                endPoint = polygonCorner.arc.getPointByAngle(polygonCorner.arc.angleEnd);
                dValue = String.valueOf(dValue) + " L " + startPoint.x + "," + startPoint.y + " A " + polygonCorner.arc.rx + " " + polygonCorner.arc.ry + " 0 0 " + clockDirection + " " + endPoint.x + "," + endPoint.y;
            } else {
                dValue = String.valueOf(dValue) + " L " + polygonCorner.x + "," + polygonCorner.y;
            }
            ++i;
        }
        dValue = String.valueOf(dValue) + " z";
        path.setDValue(dValue);
        path.setFillColor(SVGConvertHelper.convertColorToSVGColor(this.fillColor));
        path.setFillOpacity((double)this.fillAlpha / 255.0);
        path.writeXMLBody(outputstream, indention);
    }
}

