/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.svg;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.Color;
import de.plans.lib.svg.EOSVGCircle;
import de.plans.lib.svg.SVGAbstractConverter;
import de.plans.lib.svg.SVGConvertHelper;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class SVGPoint
extends SVGAbstractConverter {
    private final Point point;
    private final Color pointColor;
    private final double lineWidth;

    public SVGPoint(Point point, Color pointColor, double lineWidth) {
        assert (point != null);
        assert (pointColor != null) : "pointColor = null";
        assert (lineWidth >= -1.0E-10) : "lineWidth < null";
        this.point = point;
        this.pointColor = pointColor;
        this.lineWidth = lineWidth;
    }

    @Override
    public void writeToXML(EncodableObjectBase.WriteContext writeContext, int indention) throws EXEncoderException {
        EOSVGCircle svgCircle = new EOSVGCircle();
        svgCircle.setCx(this.point.x);
        svgCircle.setCy(this.point.y);
        svgCircle.setR(this.lineWidth / 2.0);
        svgCircle.setCircleColor(SVGConvertHelper.convertColorToSVGColor(this.pointColor));
        svgCircle.writeXMLBody(writeContext, indention);
    }
}

