/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.svg;

import com.arcway.lib.geometry.Line;
import com.arcway.lib.graphics.Color;
import de.plans.lib.svg.EOSVGLine;
import de.plans.lib.svg.SVGAbstractConverter;
import de.plans.lib.svg.SVGConvertHelper;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class SVGLine
extends SVGAbstractConverter {
    private final Line line;
    private final double lineWidth;
    private final Color lineColor;

    public SVGLine(Line line, Color lineColor, double lineWidth) {
        assert (line != null);
        assert (lineColor != null) : "lineColor = null";
        assert (lineWidth >= -1.0E-10) : "lineWidth < null";
        this.line = line;
        this.lineColor = lineColor;
        this.lineWidth = lineWidth;
    }

    @Override
    public void writeToXML(EncodableObjectBase.WriteContext writeContext, int indention) throws EXEncoderException {
        EOSVGLine svgLine = new EOSVGLine();
        svgLine.setX1(this.line.start.x);
        svgLine.setX2(this.line.end.x);
        svgLine.setY1(this.line.start.y);
        svgLine.setY2(this.line.end.y);
        svgLine.setLineColor(SVGConvertHelper.convertColorToSVGColor(this.lineColor));
        svgLine.setLineWidth(this.lineWidth);
        svgLine.setLineCap("round");
        svgLine.writeXMLBody(writeContext, indention);
    }
}

