/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.svg;

import com.arcway.lib.codec.Base64;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import de.plans.lib.svg.EOSVGImage;
import de.plans.lib.svg.SVGAbstractConverter;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.io.UnsupportedEncodingException;

public class SVGImage
extends SVGAbstractConverter {
    private final IOffscreenBitmap image;
    private final TurnedRectangle scaleToRectangle;

    public SVGImage(IOffscreenBitmap image, TurnedRectangle scaleToRectangle) {
        assert (image != null);
        assert (scaleToRectangle != null);
        this.image = image;
        this.scaleToRectangle = scaleToRectangle;
    }

    @Override
    public void writeToXML(EncodableObjectBase.WriteContext writeContext, int indention) throws EXEncoderException {
        EOSVGImage svgImage = new EOSVGImage();
        svgImage.setX(this.scaleToRectangle.getUpperLeft().x);
        svgImage.setY(this.scaleToRectangle.getUpperLeft().y);
        svgImage.setWidth(this.scaleToRectangle.getW().abs());
        svgImage.setHeight(this.scaleToRectangle.getH().abs());
        double angle = this.scaleToRectangle.getDirection().getAngle();
        if (!Geo.isZero((double)(Geo.getNormalizedAngle((double)(angle + 1.0E-10)) % 360.0 - 1.0E-10))) {
            svgImage.setTransformation("rotate(" + Double.toString(-angle) + " " + Double.toString(this.scaleToRectangle.getUpperLeft().x) + " " + Double.toString(this.scaleToRectangle.getUpperLeft().y) + ")");
        }
        svgImage.setUri(this.getImageURI());
        svgImage.writeXMLBody(writeContext, indention);
    }

    private String getImageURI() throws EXEncoderException {
        StringBuffer imageUri;
        try {
            ImageFileType imageFileType = this.image.isLossyImage() ? ImageCoDec.JPG : ImageCoDec.PNG;
            byte[] content = ImageCoDec.encodeIntoByteArray((IOffscreenBitmap)this.image, (double)96.0, (double)96.0, (ImageFileType)imageFileType);
            byte[] encodeBytes = Base64.encodeBytes((byte[])content, (boolean)false);
            imageUri = new StringBuffer("data:image/" + imageFileType.getFileExtension() + ";base64,");
            imageUri.append(new String(encodeBytes, "US-ASCII"));
        }
        catch (EXImageTooBig e) {
            throw new EXEncoderException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new EXEncoderException((Throwable)e);
        }
        catch (EXNoMoreHandles e) {
            throw new EXEncoderException((Throwable)e);
        }
        return imageUri.toString();
    }
}

