/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.resources;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.resources.IIconResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ImageIconResource
implements IIconResource {
    private static final ILogger LOGGER = Logger.getLogger(ImageIconResource.class);
    private final String name;
    private final Image image;

    public ImageIconResource(String name, Image image) {
        this.name = name;
        this.image = image;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getInputStream() {
        ByteArrayOutputStream imageDataByteArray = new ByteArrayOutputStream();
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{this.image.getImageData()};
        imageLoader.save((OutputStream)imageDataByteArray, 2);
        return new ByteArrayInputStream(imageDataByteArray.toByteArray());
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)this.image);
    }

    @Override
    public Image getImage() {
        return this.image;
    }
}

