/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.localisation;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DateFormatHelper {
    private static ThreadLocal<Map<Locale, DateFormat>> tlTimeFormats = new ThreadLocal<Map<Locale, DateFormat>>(){

        @Override
        protected Map<Locale, DateFormat> initialValue() {
            return new HashMap<Locale, DateFormat>();
        }
    };
    private static ThreadLocal<Map<Locale, DateFormat>> tlDateFormats = new ThreadLocal<Map<Locale, DateFormat>>(){

        @Override
        protected Map<Locale, DateFormat> initialValue() {
            return new HashMap<Locale, DateFormat>();
        }
    };
    private static DateFormatHelper singletonInstance;

    private DateFormatHelper() {
    }

    public static DateFormatHelper getDefault() {
        if (singletonInstance == null) {
            singletonInstance = new DateFormatHelper();
        }
        return singletonInstance;
    }

    public DateFormat getDateFormat(Locale locale) {
        DateFormat dateFormat = tlDateFormats.get().get(locale);
        if (dateFormat == null) {
            dateFormat = locale.getLanguage().equals(new Locale("de").getLanguage()) ? new SimpleDateFormat("dd.MM.yyyy") : (locale.getLanguage().equals(new Locale("en").getLanguage()) ? new SimpleDateFormat("MM/dd/yyyy") : DateFormat.getDateInstance(3, locale));
            tlDateFormats.get().put(locale, dateFormat);
        }
        return dateFormat;
    }

    public DateFormat getDateTimeFormat(Locale locale) {
        DateFormat timeFormat = tlTimeFormats.get().get(locale);
        if (timeFormat == null) {
            timeFormat = locale.getLanguage().equals(new Locale("de").getLanguage()) ? new SimpleDateFormat("dd.MM.yyyy HH:mm") : (locale.getLanguage().equals(new Locale("en").getLanguage()) ? new SimpleDateFormat("MM/dd/yyyy hh:mm aa") : DateFormat.getDateTimeInstance(3, 3, locale));
            tlTimeFormats.get().put(locale, timeFormat);
        }
        return timeFormat;
    }

    public Date parse(String dateString) {
        return this.parse(dateString, null, null);
    }

    public Date parse(String dateString, Locale expectedLocale) {
        return this.parse(dateString, expectedLocale, null);
    }

    public Date parse(String dateString, Locale expectedLocale, TimeZone timezone) {
        if (expectedLocale != null) {
            try {
                DateFormat dateFormat = this.getDateFormat(expectedLocale);
                if (timezone != null) {
                    dateFormat.setTimeZone(timezone);
                }
                return dateFormat.parse(dateString);
            }
            catch (ParseException dateFormat) {
                try {
                    DateFormat dateFormat2 = this.getDateTimeFormat(expectedLocale);
                    if (timezone != null) {
                        dateFormat2.setTimeZone(timezone);
                    }
                    return dateFormat2.parse(dateString);
                }
                catch (ParseException dateFormat2) {
                    // empty catch block
                }
            }
        }
        if (expectedLocale != null) {
            try {
                DateFormat dateFormat = DateFormat.getDateInstance(2, expectedLocale);
                if (timezone != null) {
                    dateFormat.setTimeZone(timezone);
                }
                return dateFormat.parse(dateString);
            }
            catch (ParseException dateFormat) {
                try {
                    DateFormat dateFormat3 = DateFormat.getDateTimeInstance(2, 2, expectedLocale);
                    if (timezone != null) {
                        dateFormat3.setTimeZone(timezone);
                    }
                    return dateFormat3.parse(dateString);
                }
                catch (ParseException dateFormat3) {
                    // empty catch block
                }
            }
        }
        try {
            DateFormat dateFormat = this.getDateFormat(Locale.getDefault());
            if (timezone != null) {
                dateFormat.setTimeZone(timezone);
            }
            return dateFormat.parse(dateString);
        }
        catch (ParseException dateFormat) {
            try {
                DateFormat dateFormat4 = this.getDateTimeFormat(Locale.getDefault());
                if (timezone != null) {
                    dateFormat4.setTimeZone(timezone);
                }
                return dateFormat4.parse(dateString);
            }
            catch (ParseException dateFormat4) {
                try {
                    DateFormat dateFormat5 = DateFormat.getDateInstance();
                    if (timezone != null) {
                        dateFormat5.setTimeZone(timezone);
                    }
                    return dateFormat5.parse(dateString);
                }
                catch (ParseException dateFormat5) {
                    try {
                        DateFormat dateFormat6 = DateFormat.getDateTimeInstance();
                        if (timezone != null) {
                            dateFormat6.setTimeZone(timezone);
                        }
                        return dateFormat6.parse(dateString);
                    }
                    catch (ParseException parseException) {
                        return null;
                    }
                }
            }
        }
    }
}

