/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.eclipse;

import de.plans.lib.util.gui.IProgressDisplay;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressDisplayToJFaceProgressMonitorAdapter
implements IProgressMonitor {
    private final IProgressDisplay targetDisplay;
    private boolean cancelRequest = false;
    private boolean started = false;
    private boolean unquantified;
    private int lastReportedWork = 0;

    public ProgressDisplayToJFaceProgressMonitorAdapter(IProgressDisplay targetDisplay) {
        this.targetDisplay = targetDisplay;
    }

    public void beginTask(String name, int totalWork) {
        if (totalWork == -1) {
            this.unquantified = true;
            this.targetDisplay.beginUnquantifiedTask(name, true);
        } else {
            this.unquantified = false;
            this.targetDisplay.beginQuantifiedTask(name, totalWork, true);
        }
        this.started = true;
    }

    public void done() {
        this.targetDisplay.endTask();
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.cancelRequest || this.targetDisplay.isTaskToCancel();
    }

    public void setCanceled(boolean value) {
        this.cancelRequest = true;
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
        if (this.started) {
            if (this.unquantified) {
                this.targetDisplay.reportUnquantifiedProgress(name);
            } else {
                this.targetDisplay.reportQuantifiedProgress(this.lastReportedWork, name);
            }
        }
    }

    public void worked(int work) {
        if (this.started && !this.unquantified) {
            this.lastReportedWork += work;
            this.targetDisplay.reportQuantifiedProgress(this.lastReportedWork);
        }
    }
}

