/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.eclipse;

import de.plans.lib.eclipse.Messages;
import de.plans.lib.util.LogCategory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class LoggerCategoriesMgr {
    private static final String EXTENSION_POINT_ID_LOG_CATEGORY = "logcategory";
    private static final String CONFIG_ELEMENT_NAME_LOG_CATEGORY = "logcategory";
    private static final String ATTR_LOG_COMPONENT = "component";
    private static final String ATTR_LOG_CATEGORY_ID = "id";
    private static final String ATTR_LOG_CATEGORY_NAME = "name";
    private static final String ATTR_LOG_CATEGORY_DESCRIPTION = "description";
    private static List logCategories = null;

    public static List getLogCategories() {
        if (logCategories == null) {
            logCategories = LoggerCategoriesMgr.readLogCategories();
            assert (logCategories != null) : "readLogCategories() returned null";
        }
        return logCategories;
    }

    private static List readLogCategories() {
        IExtension[] extensions;
        LogCategory[] logCategories = new LogCategory[200];
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.arcway.lib.ps.client", "logcategory");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if ("logcategory".equals(currentConfigElement.getName())) {
                    int id;
                    String component = currentConfigElement.getAttribute(ATTR_LOG_COMPONENT);
                    String idAsString = currentConfigElement.getAttribute(ATTR_LOG_CATEGORY_ID);
                    String name = currentConfigElement.getAttribute(ATTR_LOG_CATEGORY_NAME);
                    String description = currentConfigElement.getAttribute(ATTR_LOG_CATEGORY_DESCRIPTION);
                    if (idAsString != null && name != null && (id = Integer.valueOf(idAsString).intValue()) >= 0 && id < 200) {
                        if (logCategories[id] == null) {
                            logCategories[id] = new LogCategory(component, id, name, description);
                        } else {
                            String errorDescription = logCategories[id].getDescription();
                            errorDescription = errorDescription == null ? "Duplicated entry for this log category by: " + name : String.valueOf(errorDescription) + ", " + name;
                            logCategories[id] = new LogCategory(component, id, String.valueOf(Messages.getString("LoggerCategoriesMgr.WARNING_!_DUPLICATED_ENTRY_FOR_CATEGORY__9")) + id, errorDescription);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        ArrayList<LogCategory> categoryList = new ArrayList<LogCategory>();
        LogCategory[] logCategoryArray = logCategories;
        int n5 = logCategories.length;
        n = 0;
        while (n < n5) {
            LogCategory element = logCategoryArray[n];
            if (element != null) {
                categoryList.add(element);
            }
            ++n;
        }
        return categoryList;
    }
}

