/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.eclipse;

import de.plans.lib.PSLibPlugIn;
import de.plans.lib.util.gui.IProgressDisplay;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JFaceProgressMonitorToProgressDisplayAdapter
implements IProgressDisplay {
    private final IProgressMonitor targetMonitor;
    private int workReported = 0;

    public JFaceProgressMonitorToProgressDisplayAdapter(IProgressMonitor targetMonitor) {
        this.targetMonitor = targetMonitor;
    }

    @Override
    public void beginUnquantifiedTask(String taskName, boolean mayBeCanceled) {
        assert (taskName != null);
        this.targetMonitor.beginTask(taskName, -1);
    }

    @Override
    public void reportUnquantifiedProgress(String whatsNext) {
        if (whatsNext == null) {
            this.targetMonitor.subTask("");
        } else {
            this.targetMonitor.subTask(whatsNext);
        }
    }

    @Override
    public void beginQuantifiedTask(String taskName, int workTotal, boolean mayBeCanceled) {
        assert (taskName != null);
        assert (workTotal > 0);
        this.targetMonitor.beginTask(taskName, workTotal);
    }

    @Override
    public void reportQuantifiedProgress(int workSinceBeginning, String whatsNext) {
        if (whatsNext == null) {
            this.targetMonitor.subTask("");
        } else {
            this.targetMonitor.subTask(whatsNext);
        }
        this.reportWork(workSinceBeginning);
    }

    @Override
    public void reportQuantifiedProgress(int workSinceBeginning) {
        assert (workSinceBeginning >= 0);
        this.reportWork(workSinceBeginning);
    }

    @Override
    public boolean isTaskToCancel() {
        return this.targetMonitor.isCanceled();
    }

    @Override
    public void reportCancelingInProgress() {
        this.targetMonitor.subTask("Canceling ...");
    }

    public void setDisplayProgressIsBlocked(String reason) {
        if (this.targetMonitor instanceof IProgressMonitorWithBlocking) {
            ((IProgressMonitorWithBlocking)this.targetMonitor).setBlocked((IStatus)new Status(2, PSLibPlugIn.getDefault().getBundle().getSymbolicName(), reason));
        } else assert (false) : "Unsupported for the wrapped progress monitor";
    }

    public void unsetDisplayProgressIsBlocked() {
        if (this.targetMonitor instanceof IProgressMonitorWithBlocking) {
            ((IProgressMonitorWithBlocking)this.targetMonitor).clearBlocked();
        } else assert (false) : "Unsupported for the wrapped progress monitor";
    }

    @Override
    public void endTask() {
        this.targetMonitor.done();
    }

    private void reportWork(int workSinceBeginning) {
        this.targetMonitor.worked(workSinceBeginning - this.workReported);
        this.workReported = workSinceBeginning;
    }
}

