/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.eclipse;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileUtils {
    private static final String EXTENSION_SEPERATOR;

    static {
        Path pathWithoutExtension = new Path("nix");
        String nameWithoutExtension = pathWithoutExtension.lastSegment();
        int lengthWithoutExtension = nameWithoutExtension.length();
        IPath pathWithExtension = pathWithoutExtension.addFileExtension("xyz");
        String nameWithExtension = pathWithExtension.lastSegment();
        int lengthWithExtension = nameWithExtension.length();
        EXTENSION_SEPERATOR = nameWithExtension.substring(lengthWithoutExtension, lengthWithExtension - 3);
    }

    private FileUtils() {
    }

    public static String forceExtension(String fileName, String newExtension) {
        String withoutExtension = FileUtils.withoutExtension(fileName);
        String withNewExtension = String.valueOf(withoutExtension) + EXTENSION_SEPERATOR + newExtension;
        return withNewExtension;
    }

    public static String withoutExtension(String fileName) {
        Path oldPath = new Path(fileName);
        String oldExtension = oldPath.getFileExtension();
        String withoutExtension = oldExtension != null ? fileName.substring(0, fileName.length() - EXTENSION_SEPERATOR.length() - oldExtension.length()) : fileName;
        return withoutExtension;
    }

    public static boolean validFileName(String fileName) {
        if (fileName.indexOf(File.separatorChar) > -1) {
            return false;
        }
        return fileName.indexOf(File.pathSeparatorChar) <= -1;
    }
}

