/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.eclipse;

import com.arcway.lib.eclipse.transfer.AbstractTransferAgent;
import com.arcway.lib.eclipse.transfer.ExByteArrayDecodingFailed;
import com.arcway.lib.eclipse.transfer.ExByteArrayEncodingFailed;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.UnsupportedEncodingException;

public abstract class AbstractStringTransferAgent
extends AbstractTransferAgent {
    private static final ILogger logger = Logger.getLogger(AbstractStringTransferAgent.class);

    public AbstractStringTransferAgent(String typeName) {
        super(typeName);
    }

    protected byte[] javaToByteArray(Object dataAsObject) throws ExByteArrayEncodingFailed {
        if (!(dataAsObject instanceof String)) {
            logger.error("Unknown type. Need string");
            return null;
        }
        String UID = (String)dataAsObject;
        try {
            return UID.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ExByteArrayEncodingFailed("UTF-8 must be supported", (Throwable)e);
        }
    }

    protected Object byteArrayToJava(byte[] dataAsByteArray, int dataStartPos, int dataLength) throws ExByteArrayDecodingFailed {
        try {
            return new String(dataAsByteArray, dataStartPos, dataLength, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ExByteArrayDecodingFailed("UTF-8 must be supported", (Throwable)e);
        }
    }
}

