/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.treeviews;

import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.treeviews.ITreeView;
import com.arcway.lib.ui.treeviews.ITreeViewListener;
import com.arcway.lib.ui.treeviews.ITreeViewSwitchAgent;
import com.arcway.lib.ui.treeviews.TreeViewNodeWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TreeViewSwitchAgent
implements ITreeViewSwitchAgent,
ITreeViewListener {
    private final Map<Object, ITreeView> treeViews = new HashMap<Object, ITreeView>();
    private ITreeViewListener treeViewListener;
    private PresentationContext presentationContext;
    private long timeOfRefresh;

    public TreeViewSwitchAgent(PresentationContext presentationContext) {
        this.setPresentationContext(presentationContext);
    }

    @Override
    public Object getInvisibleRoot() {
        return this;
    }

    @Override
    public void addTreeView(Object key, ITreeView treeView) {
        if (this.treeViews.containsKey(key)) {
            throw new IllegalArgumentException("The key is alreaydy used within TreeViewSwitchAgent's hashmap");
        }
        this.treeViews.put(key, treeView);
        treeView.setupTreeViewListener(this);
    }

    @Override
    public Object[] getAllTreeViewKeys() {
        return this.treeViews.keySet().toArray();
    }

    @Override
    public boolean hasChildNodes(Object parentNode) {
        if (parentNode == this.getInvisibleRoot()) {
            return this.getAllTreeViewKeys().length > 0;
        }
        if (parentNode instanceof TreeViewNodeWrapper) {
            TreeViewNodeWrapper wrapperedNode = (TreeViewNodeWrapper)parentNode;
            ITreeView treeView = this.treeViews.get(wrapperedNode.getTreeViewKey());
            if (treeView != null) {
                return treeView.hasChildNodes(wrapperedNode.getNode());
            }
            return false;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object[] getChildNodes(Object parentNode) {
        if (parentNode == this.getInvisibleRoot()) {
            Object[] result = this.getAllTreeViewKeys();
            ArrayList<TreeViewNodeWrapper> wrappedResult = new ArrayList<TreeViewNodeWrapper>();
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                ITreeView treeView = this.treeViews.get(key);
                if (treeView != null) {
                    Object[] objectArray2 = treeView.getChildNodes(treeView.getInvisibleRoot());
                    int n3 = objectArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object child = objectArray2[n4];
                        wrappedResult.add(new TreeViewNodeWrapper(child, key));
                        ++n4;
                    }
                }
                ++n2;
            }
            return wrappedResult.toArray();
        }
        if (parentNode instanceof TreeViewNodeWrapper) {
            TreeViewNodeWrapper wrapperedNode = (TreeViewNodeWrapper)parentNode;
            Object key = wrapperedNode.getTreeViewKey();
            ITreeView treeView = this.treeViews.get(key);
            if (treeView != null) {
                Object[] result = treeView.getChildNodes(wrapperedNode.getNode());
                Object[] wrappedResult = new TreeViewNodeWrapper[result.length];
                int i = 0;
                while (i < result.length) {
                    wrappedResult[i] = new TreeViewNodeWrapper(result[i], key);
                    ++i;
                }
                return wrappedResult;
            }
            return new TreeViewNodeWrapper[0];
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getParentNode(Object childNode) {
        if (childNode instanceof TreeViewNodeWrapper) {
            TreeViewNodeWrapper wrapperedNode = (TreeViewNodeWrapper)childNode;
            Object key = wrapperedNode.getTreeViewKey();
            ITreeView treeView = this.treeViews.get(key);
            if (treeView != null) {
                return new TreeViewNodeWrapper(treeView.getParentNode(wrapperedNode.getNode()), key);
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IStreamResource getNodeImage(Object node) {
        if (node instanceof TreeViewNodeWrapper) {
            TreeViewNodeWrapper wrapperedNode = (TreeViewNodeWrapper)node;
            ITreeView treeView = this.treeViews.get(wrapperedNode.getTreeViewKey());
            if (treeView != null) {
                return treeView.getNodeImage(wrapperedNode.getNode());
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getNodeText(Object node) {
        if (node instanceof TreeViewNodeWrapper) {
            TreeViewNodeWrapper wrapperedNode = (TreeViewNodeWrapper)node;
            ITreeView treeView = this.treeViews.get(wrapperedNode.getTreeViewKey());
            if (treeView != null) {
                return treeView.getNodeText(wrapperedNode.getNode());
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getHashCodeForNode(Object node) {
        if (node instanceof TreeViewNodeWrapper) {
            TreeViewNodeWrapper wrapperedNode = (TreeViewNodeWrapper)node;
            ITreeView treeView = this.treeViews.get(wrapperedNode.getTreeViewKey());
            if (treeView != null) {
                return treeView.getHashCodeForNode(wrapperedNode.getNode());
            }
            return 0;
        }
        return node.hashCode();
    }

    @Override
    public boolean areEqualNodes(Object node1, Object node2) {
        if (node1 instanceof TreeViewNodeWrapper && node2 instanceof TreeViewNodeWrapper) {
            TreeViewNodeWrapper wrapperedNode1 = (TreeViewNodeWrapper)node1;
            TreeViewNodeWrapper wrapperedNode2 = (TreeViewNodeWrapper)node2;
            ITreeView treeView = this.treeViews.get(wrapperedNode1.getTreeViewKey());
            if (treeView != null) {
                return treeView.areEqualNodes(wrapperedNode1.getNode(), wrapperedNode2.getNode());
            }
            return false;
        }
        return node1.equals(node2);
    }

    @Override
    public Object getItemForNode(Object node) {
        if (node instanceof TreeViewNodeWrapper) {
            TreeViewNodeWrapper wrapperedNode = (TreeViewNodeWrapper)node;
            ITreeView treeView = this.treeViews.get(wrapperedNode.getTreeViewKey());
            if (treeView != null) {
                return treeView.getItemForNode(wrapperedNode.getNode());
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getNodeForItem(Object item) {
        for (Map.Entry<Object, ITreeView> entry : this.treeViews.entrySet()) {
            Object result = entry.getValue().getNodeForItem(item);
            if (result == null) continue;
            return new TreeViewNodeWrapper(result, entry.getKey());
        }
        return null;
    }

    @Override
    public PresentationContext getPresentationContext() {
        return this.presentationContext;
    }

    @Override
    public void setPresentationContext(PresentationContext presentationContext) {
        this.presentationContext = presentationContext;
        for (Map.Entry<Object, ITreeView> entry : this.treeViews.entrySet()) {
            entry.getValue().setPresentationContext(presentationContext);
        }
        this.timeOfRefresh = Long.MAX_VALUE;
    }

    @Override
    public void treeViewChanged() {
        if (this.treeViewListener != null) {
            this.treeViewListener.treeViewChanged();
        }
    }

    @Override
    public void treeViewHasNewExparationTime(long exparationTime) {
        if (exparationTime < this.timeOfRefresh) {
            this.timeOfRefresh = exparationTime;
            if (this.treeViewListener != null) {
                this.treeViewListener.treeViewHasNewExparationTime(this.timeOfRefresh);
            }
        }
    }

    @Override
    public void treeViewIsShuttingDown(Object key) {
        if (this.removeTreeView(key)) {
            this.treeViewChanged();
        }
    }

    @Override
    public void setupTreeViewListener(ITreeViewListener treeViewListener) {
        if (this.treeViewListener != null) {
            throw new IllegalArgumentException("setupTreeViewListener() was called twice");
        }
        this.treeViewListener = treeViewListener;
    }

    @Override
    public boolean removeTreeView(Object key) {
        if (this.treeViews.containsKey(key)) {
            this.treeViews.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        for (Map.Entry<Object, ITreeView> entry : this.treeViews.entrySet()) {
            entry.getValue().dispose();
        }
        this.treeViewListener = null;
    }
}

