/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.treeviews;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.contextmenus.ContextMenuManager;
import com.arcway.lib.ui.contextmenus.IContextMenuEntry;
import com.arcway.lib.ui.contextmenus.IContextMenuManager;
import com.arcway.lib.ui.dnd.DragNDropManager;
import com.arcway.lib.ui.dnd.IDragNDropManager;
import com.arcway.lib.ui.dnd.IModelDragHandler;
import com.arcway.lib.ui.dnd.IModelDropHandler;
import com.arcway.lib.ui.treeviews.ITreeView;
import com.arcway.lib.ui.treeviews.ITreeViewFrontendAgent;
import com.arcway.lib.ui.treeviews.ITreeViewListener;
import java.util.ArrayList;
import java.util.Collection;

public class TreeViewFrontendAgent
implements ITreeViewFrontendAgent,
ITreeViewListener {
    private final ITreeView treeView;
    private final IContextMenuManager contextMenuManager;
    private final IDragNDropManager dragNDropManager;
    private ITreeViewListener treeViewListener;

    public TreeViewFrontendAgent(ITreeView treeView) {
        this.treeView = treeView;
        treeView.setupTreeViewListener(this);
        this.contextMenuManager = ContextMenuManager.getContextMenuManager();
        this.dragNDropManager = DragNDropManager.getDragNDropManager();
    }

    @Override
    public Object getInvisibleRoot() {
        return this.treeView.getInvisibleRoot();
    }

    @Override
    public Object getParentNode(Object childNode) {
        return this.treeView.getParentNode(childNode);
    }

    @Override
    public boolean hasChildNodes(Object parentNode) {
        return this.treeView.hasChildNodes(parentNode);
    }

    @Override
    public Object[] getChildNodes(Object parentNode) {
        return this.treeView.getChildNodes(parentNode);
    }

    @Override
    public String getNodeText(Object node) {
        return this.treeView.getNodeText(node);
    }

    @Override
    public IStreamResource getNodeImage(Object node) {
        return this.treeView.getNodeImage(node);
    }

    @Override
    public boolean areEqualNodes(Object node1, Object node2) {
        return this.treeView.areEqualNodes(node1, node2);
    }

    @Override
    public int getHashCodeForNode(Object node) {
        return this.treeView.getHashCodeForNode(node);
    }

    @Override
    public void setPresentationContext(PresentationContext presentationContext) {
        this.treeView.setPresentationContext(presentationContext);
    }

    @Override
    public PresentationContext getPresentationContext() {
        return this.treeView.getPresentationContext();
    }

    @Override
    public Object getItemForNode(Object node) {
        return this.treeView.getItemForNode(node);
    }

    @Override
    public Object getNodeForItem(Object item) {
        return this.treeView.getNodeForItem(item);
    }

    @Override
    public IContextMenuEntry[] getContextMenuEntries(Object[] selection) {
        Object[] items = new Object[selection.length];
        int i = 0;
        while (i < selection.length) {
            items[i] = this.getItemForNode(selection[i]);
            ++i;
        }
        return this.contextMenuManager.getContextMenuEntries(items);
    }

    @Override
    public IModelDragHandler getModelDragHandler(Collection<Object> selectedItems, int operation) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object sItem : selectedItems) {
            items.add(this.getItemForNode(sItem));
        }
        return this.dragNDropManager.getModelDragHandler(items, operation);
    }

    @Override
    public IModelDropHandler getModelDropHandler(Object droppedElements, Object targetFolderElement, int operation) {
        return this.dragNDropManager.getModelDropHandler(droppedElements, this.getItemForNode(targetFolderElement), operation);
    }

    @Override
    public IDataType[] getDragDataTypes(int operation) {
        return this.dragNDropManager.getDragDataTypes(operation);
    }

    @Override
    public IDataType[] getDropDataTypes(int operation) {
        return this.dragNDropManager.getDropDataTypes(operation);
    }

    @Override
    public void dispose() {
        this.treeView.dispose();
        this.treeViewListener = null;
    }

    @Override
    public void treeViewChanged() {
        if (this.treeViewListener != null) {
            this.treeViewListener.treeViewChanged();
        }
    }

    @Override
    public void treeViewHasNewExparationTime(long exparationTime) {
        if (this.treeViewListener != null) {
            this.treeViewListener.treeViewHasNewExparationTime(exparationTime);
        }
    }

    @Override
    public void treeViewIsShuttingDown(Object key) {
        if (this.treeViewListener != null) {
            this.treeViewListener.treeViewIsShuttingDown(key);
        }
    }

    @Override
    public void setupTreeViewListener(ITreeViewListener treeViewListener) {
        if (this.treeViewListener != null) {
            throw new IllegalArgumentException("setupTreeViewListener() was called twice");
        }
        this.treeViewListener = treeViewListener;
    }
}

