/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.file;

import com.arcway.lib.io.FileHelper;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.file.UIFileValidator;
import java.io.File;
import java.util.Collection;
import org.eclipse.osgi.util.NLS;

public class ExtensionFileValidator
extends UIFileValidator {
    private final Collection<String> extensions;
    private final String message_nonExistingFile_Cause;
    private final String message_nonExistingFile_Consequence;
    private final String message_wrongExtension_Cause;
    private final String message_wrongExtension_Consequence;

    public ExtensionFileValidator(Collection<String> extensions, String message_nonExistingFile_Cause, String message_nonExistingFile_Consequence, String message_wrongExtension_Cause, String message_wrongExtension_Consequence) {
        this.extensions = extensions;
        this.message_nonExistingFile_Cause = message_nonExistingFile_Cause;
        this.message_nonExistingFile_Consequence = message_nonExistingFile_Consequence;
        this.message_wrongExtension_Cause = message_wrongExtension_Cause;
        this.message_wrongExtension_Consequence = message_wrongExtension_Consequence;
    }

    @Override
    public IModificationProblem getInvalidityReason(File file) {
        if (file == null) {
            return new IModificationProblem(){

                @Override
                public String getHumanReadableDescriptionOfCause() {
                    return ExtensionFileValidator.this.fillInExtensionIntoMessageIfRequired(ExtensionFileValidator.this.message_nonExistingFile_Cause);
                }

                @Override
                public String getHumanReadableDescriptionOfConsequence() {
                    return ExtensionFileValidator.this.fillInExtensionIntoMessageIfRequired(ExtensionFileValidator.this.message_nonExistingFile_Consequence);
                }

                @Override
                public int getSeverity() {
                    return 2;
                }
            };
        }
        String currentFilesExtension = FileHelper.getFileExtension((File)file).toLowerCase();
        if (!this.extensions.contains(currentFilesExtension)) {
            return new IModificationProblem(){

                @Override
                public String getHumanReadableDescriptionOfCause() {
                    return ExtensionFileValidator.this.fillInExtensionIntoMessageIfRequired(ExtensionFileValidator.this.message_wrongExtension_Cause);
                }

                @Override
                public String getHumanReadableDescriptionOfConsequence() {
                    return ExtensionFileValidator.this.fillInExtensionIntoMessageIfRequired(ExtensionFileValidator.this.message_wrongExtension_Consequence);
                }

                @Override
                public int getSeverity() {
                    return 3;
                }
            };
        }
        return null;
    }

    private String fillInExtensionIntoMessageIfRequired(String message) {
        if (message.indexOf("{0}") >= 0) {
            return NLS.bind((String)message, (Object)this.getSlashConcatenationOfExtensions());
        }
        return message;
    }

    private String getSlashConcatenationOfExtensions() {
        String concatenation = "";
        boolean isFirst = true;
        for (String extension : this.extensions) {
            if (isFirst) {
                isFirst = false;
            } else {
                concatenation = String.valueOf(concatenation) + "/";
            }
            concatenation = String.valueOf(concatenation) + extension;
        }
        return concatenation;
    }
}

