/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.WidgetFactoryController;
import com.arcway.lib.ui.editor.datatype.ILayoutWidget;
import com.arcway.lib.ui.editor.datatype.INonPageWidget;
import com.arcway.lib.ui.editor.datatype.IPropertyOrCategoryWidgetAdapterFactory;
import com.arcway.lib.ui.editor.datatype.IWidget;
import com.arcway.lib.ui.editor.datatype.IWidgetAdapterFactory;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.manager.WidgetAdapterFactoryManager;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractComplexWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WidgetRowWidgetGeneralWidgetAdapter
extends AbstractComplexWidgetAdapter {
    private static final ILogger logger = Logger.getLogger(WidgetRowWidgetGeneralWidgetAdapter.class);
    private final IWidgetTypeID widgetSubTypeID;
    private Collection<IEditorPlayground> comparePlaygrounds;
    private Collection<IEditorPlayground> toBePlaygrounds;
    private IDataWidgetAdapter compareWidgetAdapter;
    private IDataWidgetAdapter toBeWidgetAdapter;

    public WidgetRowWidgetGeneralWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds, WidgetAdapterFactoryManager widgetAdapterFactoryManager, Collection<String> editorDataTypeIDs, IWidgetTypeID widgetSubTypeID) {
        super(widgetAdapterManager, playgrounds);
        this.widgetSubTypeID = widgetSubTypeID;
        assert (playgrounds.size() % 2 == 0);
        assert (editorDataTypeIDs.size() == playgrounds.size());
        int playgroundsPerDataWidget = playgrounds.size() / 2;
        if (playgroundsPerDataWidget > 0) {
            this.comparePlaygrounds = new ArrayList<IEditorPlayground>(playgroundsPerDataWidget);
            this.toBePlaygrounds = new ArrayList<IEditorPlayground>(playgroundsPerDataWidget);
            int playgroundIndex = 0;
            for (IEditorPlayground playground : playgrounds) {
                if (playgroundIndex < playgroundsPerDataWidget) {
                    this.comparePlaygrounds.add(playground);
                } else {
                    this.toBePlaygrounds.add(playground);
                }
                ++playgroundIndex;
            }
            ArrayList<String> compareEditorDataTypeIDs = new ArrayList<String>(playgroundsPerDataWidget);
            ArrayList<String> toBeEditorDataTypeIDs = new ArrayList<String>(playgroundsPerDataWidget);
            int editorDataTypeIDIndex = 0;
            for (String editorDataTypeID : editorDataTypeIDs) {
                if (editorDataTypeIDIndex < playgroundsPerDataWidget) {
                    compareEditorDataTypeIDs.add(editorDataTypeID);
                } else {
                    toBeEditorDataTypeIDs.add(editorDataTypeID);
                }
                ++editorDataTypeIDIndex;
            }
            this.compareWidgetAdapter = WidgetRowWidgetGeneralWidgetAdapter.createSubWidgetAdapter(widgetAdapterFactoryManager, this.comparePlaygrounds, compareEditorDataTypeIDs, widgetSubTypeID, widgetAdapterManager);
            this.toBeWidgetAdapter = WidgetRowWidgetGeneralWidgetAdapter.createSubWidgetAdapter(widgetAdapterFactoryManager, this.toBePlaygrounds, toBeEditorDataTypeIDs, widgetSubTypeID, widgetAdapterManager);
        }
    }

    private static IDataWidgetAdapter createSubWidgetAdapter(WidgetAdapterFactoryManager widgetAdapterFactoryManager, Collection<IEditorPlayground> playgrounds, Collection<String> editorDataTypeIDs, IWidgetTypeID widgetSubTypeID, IWidgetAdapterManager widgetAdapterManager) {
        IDataWidgetAdapter subWidgetAdapter = null;
        IWidgetAdapterFactory subWidgetAdapterFactory = widgetAdapterFactoryManager.findWidgetAdapterFactory(editorDataTypeIDs, widgetSubTypeID);
        if (subWidgetAdapterFactory instanceof IPropertyOrCategoryWidgetAdapterFactory) {
            subWidgetAdapter = ((IPropertyOrCategoryWidgetAdapterFactory)subWidgetAdapterFactory).createWidgetAdapter(widgetAdapterManager, playgrounds);
            for (IEditorPlayground playground : playgrounds) {
                playground.addWidgetAdapter(subWidgetAdapter);
            }
        }
        return subWidgetAdapter;
    }

    @Override
    protected List<INonPageWidget> createSubWidgets(WidgetFactoryController widgetFactoryController, WidgetParameters widgetParameters) {
        ArrayList<INonPageWidget> subWidgets = new ArrayList<INonPageWidget>(2);
        subWidgets.add(this.createSubWidget(widgetFactoryController, widgetParameters, true, this.compareWidgetAdapter));
        subWidgets.add(this.createSubWidget(widgetFactoryController, widgetParameters, false, this.toBeWidgetAdapter));
        return subWidgets;
    }

    private INonPageWidget createSubWidget(WidgetFactoryController widgetFactoryController, WidgetParameters widgetParameters, boolean isCompareWidget, IDataWidgetAdapter widgetAdapter) {
        INonPageWidget subWidget;
        WidgetParameters subWidgetWidgetParameters = widgetParameters.copy();
        subWidgetWidgetParameters.setShowLabel(isCompareWidget);
        subWidgetWidgetParameters.setEditable(!isCompareWidget);
        subWidgetWidgetParameters.setWidgetSubTypeID(null);
        if (widgetAdapter != null) {
            subWidget = widgetAdapter.createWidget(this.widgetSubTypeID, widgetFactoryController, subWidgetWidgetParameters, this.getWidget());
        } else {
            IWidget decoratorWidget = widgetFactoryController.createLayoutWidget(this.widgetSubTypeID, subWidgetWidgetParameters, this.getCurrentPresentationContext().getLocale(), this.getWidget());
            assert (decoratorWidget instanceof ILayoutWidget);
            subWidget = (ILayoutWidget)decoratorWidget;
        }
        return subWidget;
    }

    @Override
    public void updateWidgetMessageDisplay() {
        if (this.toBeWidgetAdapter != null) {
            this.toBeWidgetAdapter.updateWidgetMessageDisplay();
        }
    }

    @Override
    public void widgetModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isModificationPermitted() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isModificationLocked() {
        throw new UnsupportedOperationException();
    }

    public IDataWidgetAdapter getCompareSubWidgetAdapter() {
        return this.compareWidgetAdapter;
    }

    public IDataWidgetAdapter getToBeSubWidgetAdapter() {
        return this.toBeWidgetAdapter;
    }

    @Override
    public void update(IWidgetAdapter.WidgetUpdateMode mode) {
    }
}

