/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.IEnumerationItem_WithLabelAndIcon;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractRelationWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IRelationsListValueRange;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RelationsListWidgetRelationWidgetAdapter
extends AbstractRelationWidgetAdapter {
    public RelationsListWidgetRelationWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds, Object objectID, Object roleID) {
        super(widgetAdapterManager, playgrounds, objectID, roleID);
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        return this.getPlayground().getCreatedAndNotDeletedRelations(this.getObjectID(), this.getRoleID(), false);
    }

    @Override
    public IRelationsListValueRange getValueRange() {
        return new IRelationsListValueRange(){
            private List<IEnumerationItem_WithLabelAndIcon> valueRangeSubsetForSelectedRelations;
            private List<IEnumerationItem_WithLabelAndIcon> completeValueRange;

            @Override
            public IEnumerationItem_WithLabelAndIcon getValueRangeItemForKey(Object key) {
                return RelationsListWidgetRelationWidgetAdapter.this.getValueRangeItemForKey(key);
            }

            @Override
            public List<IEnumerationItem_WithLabelAndIcon> getValueRangeSubsetForSelectedRelations() {
                if (this.valueRangeSubsetForSelectedRelations == null) {
                    this.valueRangeSubsetForSelectedRelations = RelationsListWidgetRelationWidgetAdapter.this.getValueRangeSubsetForSelectedRelations();
                }
                return this.valueRangeSubsetForSelectedRelations;
            }

            @Override
            public List<IEnumerationItem_WithLabelAndIcon> getCompleteValueRange() {
                if (this.completeValueRange == null) {
                    this.completeValueRange = RelationsListWidgetRelationWidgetAdapter.this.getCompleteValueRange();
                }
                return this.completeValueRange;
            }

            @Override
            public int getMinCardinality() {
                return RelationsListWidgetRelationWidgetAdapter.this.getPlayground().getMinCardinality(RelationsListWidgetRelationWidgetAdapter.this.getRoleID());
            }

            @Override
            public int getMaxCardinality() {
                return RelationsListWidgetRelationWidgetAdapter.this.getPlayground().getMaxCardinality(RelationsListWidgetRelationWidgetAdapter.this.getRoleID());
            }
        };
    }

    private IEnumerationItem_WithLabelAndIcon getValueRangeItemForKey(Object key) {
        try {
            if (this.isRelationPossible(key, false)) {
                return this.createEnumerationItem(key);
            }
            return null;
        }
        catch (EEXLockDenied eLD) {
            return null;
        }
    }

    private List<IEnumerationItem_WithLabelAndIcon> getCompleteValueRange() {
        ArrayList<IEnumerationItem_WithLabelAndIcon> enumerationItems = new ArrayList<IEnumerationItem_WithLabelAndIcon>();
        this.addEnumerationItemsForAllRelations(this.getPlayground().getRelationsThatMayBeDeleted(this.getObjectID(), this.getRoleID(), false), enumerationItems);
        this.addEnumerationItemsForAllRelations(this.getPlayground().getRelationsThatMayBeCreated(this.getObjectID(), this.getRoleID(), false), enumerationItems);
        Collections.sort(enumerationItems, new Comparator<IEnumerationItem_WithLabelAndIcon>(){

            @Override
            public int compare(IEnumerationItem_WithLabelAndIcon enumerationItem1, IEnumerationItem_WithLabelAndIcon enumerationItem2) {
                return String.CASE_INSENSITIVE_ORDER.compare(enumerationItem1.getLabel(), enumerationItem2.getLabel());
            }
        });
        return enumerationItems;
    }

    private List<IEnumerationItem_WithLabelAndIcon> getValueRangeSubsetForSelectedRelations() {
        ArrayList<IEnumerationItem_WithLabelAndIcon> enumerationItems = new ArrayList<IEnumerationItem_WithLabelAndIcon>();
        this.addEnumerationItemsForAllRelations(this.getPlayground().getCreatedAndNotDeletedRelations(this.getObjectID(), this.getRoleID(), false), enumerationItems);
        Collections.sort(enumerationItems, new Comparator<IEnumerationItem_WithLabelAndIcon>(){

            @Override
            public int compare(IEnumerationItem_WithLabelAndIcon enumerationItem1, IEnumerationItem_WithLabelAndIcon enumerationItem2) {
                return String.CASE_INSENSITIVE_ORDER.compare(enumerationItem1.getLabel(), enumerationItem2.getLabel());
            }
        });
        return enumerationItems;
    }

    private void addEnumerationItemsForAllRelations(ISet_<? extends Object> relations, List<IEnumerationItem_WithLabelAndIcon> enumerationItems) {
        for (Object relation : relations) {
            enumerationItems.add(this.createEnumerationItem(relation));
        }
    }

    private IEnumerationItem_WithLabelAndIcon createEnumerationItem(final Object relation) {
        return new IEnumerationItem_WithLabelAndIcon(){
            private String label = null;
            private IStreamResource icon = null;

            @Override
            public Object getKey() {
                return relation;
            }

            @Override
            public String getLabel() {
                if (this.label == null) {
                    this.label = RelationsListWidgetRelationWidgetAdapter.this.getPlayground().getLabel(RelationsListWidgetRelationWidgetAdapter.this.getObjectID(), RelationsListWidgetRelationWidgetAdapter.this.getRoleID(), relation);
                }
                return this.label;
            }

            @Override
            public IStreamResource getIcon() {
                if (this.icon == null) {
                    this.icon = RelationsListWidgetRelationWidgetAdapter.this.getPlayground().getIcon16x16(RelationsListWidgetRelationWidgetAdapter.this.getObjectID(), RelationsListWidgetRelationWidgetAdapter.this.getRoleID(), relation);
                }
                return this.icon;
            }
        };
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        this.removeWidgetAdapterError();
        Object value = widget.getCurrentValue();
        List valueList = (List)value;
        for (EnumerationItem enumItem : valueList) {
            if (enumItem.isChecked()) {
                this.getPlayground().addRelation(this.getObjectID(), this.getRoleID(), enumItem.getKey());
                continue;
            }
            this.getPlayground().removeRelation(this.getObjectID(), this.getRoleID(), enumItem.getKey());
        }
        this.getPlayground().updateAdapters(this);
    }

    public IDataType getObjectReferenceCollectionDataType() {
        return this.getPlayground().getObjectReferenceCollectionDataType();
    }

    public boolean isRelationPossible(Object participant, boolean checkPermissionAndAcquireLock) throws EEXLockDenied {
        return this.getPlayground().isRelationPossible(this.getObjectID(), this.getRoleID(), participant, checkPermissionAndAcquireLock);
    }

    public ITextProvider getMessageForLockingException(EEXLockDenied eLD) {
        return this.getPlayground().getMessageForLockingException(eLD);
    }

    public String getHierarchyString(IEnumerationItem_WithLabelAndIcon enumItem) {
        if (enumItem != null) {
            return this.getPlayground().getRelatedItemLocation(this.getObjectID(), this.getRoleID(), enumItem.getKey());
        }
        return "";
    }
}

