/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.Messages;
import com.arcway.lib.java.locale.LocalisationUtils;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractFreeStringWidgetNumberPropertyWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.text.ParseException;
import java.util.Collection;
import java.util.Locale;

public class FreeStringWidgetFloatPropertyWidgetAdapter
extends AbstractFreeStringWidgetNumberPropertyWidgetAdapter {
    private final PropertyPlayground playground;
    private boolean hasError = false;

    public FreeStringWidgetFloatPropertyWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
        this.playground = (PropertyPlayground)playgrounds.iterator().next();
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        try {
            this.removeWidgetAdapterError();
            this.hasError = false;
            String currentValue = (String)widget.getCurrentValue();
            try {
                Double newValue = LocalisationUtils.parseDoubleLocalized((String)currentValue, (Locale)this.getContentLocale());
                this.playground.setValue(newValue, this);
            }
            catch (ParseException pE) {
                this.hasError = true;
                ITextProvider message = Messages.getTextProvider("FreeStringWidgetFloatPropertyWidgetAdapter.errorInInput", String.valueOf(LocalisationUtils.getCommaCharacter((Locale)this.getContentLocale())));
                this.setWidgetAdapterError(message);
            }
        }
        catch (Exception e) {
            this.hasError = true;
            this.setWidgetAdapterError(null);
        }
    }
}

