/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.datatype.ConstantTextProvider;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractPropertyWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.DateWidgetDatePropertyWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.Collection;

public class DurationWidgetDurationPropertyWidgetAdapter
extends AbstractPropertyWidgetAdapter {
    private static final ILogger logger = Logger.getLogger(DateWidgetDatePropertyWidgetAdapter.class);
    private final PropertyPlayground<?, ?, ?, ?> playground;

    public DurationWidgetDurationPropertyWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
        this.playground = (PropertyPlayground)playgrounds.iterator().next();
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        Long value = (Long)this.playground.getValue();
        return value;
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        try {
            this.removeWidgetAdapterError();
            String newValue = (String)widget.getCurrentValue();
            if (newValue != null && !newValue.equals("")) {
                try {
                    Long duration = new Long(newValue);
                    this.playground.setValue(duration, this);
                }
                catch (NumberFormatException nfE) {
                    this.setWidgetAdapterError(new ConstantTextProvider(nfE.getLocalizedMessage()));
                }
            } else {
                this.playground.setValue(null, this);
            }
        }
        catch (Exception e) {
            this.setWidgetAdapterError(null);
            this.playground.setError(new PlaygroundError(IMessageLevel.NORMAL, new ConstantTextProvider(e.getLocalizedMessage())));
            logger.error("Wrong value in duration widget.", (Throwable)e);
        }
    }
}

