/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.Messages;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.playground.AbstractPropertyOrCategoryPlayground;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.IRelationPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.IRelationWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import com.arcway.lib.ui.editor.widgetAdapter.WidgetAdapterError;
import java.util.Collection;
import java.util.Locale;

public abstract class AbstractWidgetAdapter
implements IWidgetAdapter {
    private final IWidgetAdapterManager widgetAdapterManager;
    private final Collection<IEditorPlayground> playgrounds;
    private IEditorMessage error = null;

    public AbstractWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        this.widgetAdapterManager = widgetAdapterManager;
        this.playgrounds = playgrounds;
    }

    @Override
    public boolean isModificationPermitted() {
        for (IEditorPlayground playground : this.playgrounds) {
            if (!(playground instanceof IRelationPlayground && this instanceof IRelationWidgetAdapter ? !((IRelationPlayground)playground).isModificationPermitted(((IRelationWidgetAdapter)((Object)this)).getObjectID(), ((IRelationWidgetAdapter)((Object)this)).getRoleID()) : !((AbstractPropertyOrCategoryPlayground)playground).isModificationPermitted())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isModificationLocked() {
        for (IEditorPlayground playground : this.playgrounds) {
            if (playground.isModificationLocked()) continue;
            return false;
        }
        return true;
    }

    public final boolean hasWidgetAdapterError() {
        return this.error != null;
    }

    @Override
    public final boolean hasError() {
        if (this.error != null) {
            return true;
        }
        for (IEditorPlayground playground : this.playgrounds) {
            if (!(playground instanceof IRelationPlayground && this instanceof IRelationWidgetAdapter ? ((IRelationPlayground)playground).hasError(((IRelationWidgetAdapter)((Object)this)).getRoleID(), ((IRelationWidgetAdapter)((Object)this)).getObjectID()) : playground.hasError())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getLockMessage() {
        for (IEditorPlayground playground : this.playgrounds) {
            String playgroundLockMessageText = playground.getLockMessageText();
            if (playgroundLockMessageText == null) continue;
            return playgroundLockMessageText;
        }
        return null;
    }

    @Override
    public String getPermissionMessage() {
        for (IEditorPlayground playground : this.playgrounds) {
            String playgroundPermissionMessageText = playground.getPermissionMessageText();
            if (playgroundPermissionMessageText == null) continue;
            return playgroundPermissionMessageText;
        }
        return null;
    }

    public IEditorMessage getWidgetAdapterError() {
        return this.error;
    }

    @Override
    public IEditorMessage getErrorMessage() {
        if (this.error != null) {
            return this.error;
        }
        for (IEditorPlayground playground : this.playgrounds) {
            if (playground instanceof IRelationPlayground && this instanceof IRelationWidgetAdapter) {
                Object objectID;
                IRelationPlayground relationPlayground = (IRelationPlayground)playground;
                IRelationWidgetAdapter relationWidgetAdapter = (IRelationWidgetAdapter)((Object)this);
                Object roleID = relationWidgetAdapter.getRoleID();
                if (!relationPlayground.hasError(roleID, objectID = relationWidgetAdapter.getObjectID())) continue;
                return relationPlayground.getError(roleID, objectID);
            }
            if (!playground.hasError()) continue;
            return playground.getError();
        }
        return null;
    }

    @Override
    public void setWidgetAdapterError(ITextProvider errorMsg) {
        this.setWidgetAdapterError(errorMsg, IMessageLevel.NORMAL);
    }

    @Override
    public void setWidgetAdapterError(ITextProvider errorMsg, IMessageLevel errorLevel) {
        this.error = errorMsg != null && errorLevel != null ? new WidgetAdapterError(errorLevel, errorMsg) : (errorMsg != null && errorLevel == null ? new WidgetAdapterError(IMessageLevel.NORMAL, errorMsg) : new WidgetAdapterError(IMessageLevel.NORMAL, Messages.getTextProvider("WidgetAdapter.wrongValue", new String[0])));
        this.updateWidgetMessageDisplay();
        this.widgetAdapterManager.errorInWidgetAdapter(this, this.error);
    }

    @Override
    public void updateWidgetMessageDisplay() {
        this.getWidget().updateWidgetMessageDisplay();
    }

    @Override
    public void removeWidgetAdapterError() {
        if (this.error != null) {
            this.widgetAdapterManager.removeError(this);
            this.error = null;
            this.updateWidgetMessageDisplay();
        }
    }

    @Override
    public Object getValueRange() {
        return null;
    }

    @Override
    public IHasher_ getKeyHasher() {
        return null;
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        return null;
    }

    @Override
    public void update(IWidgetAdapter.WidgetUpdateMode mode) {
        this.getWidget().updateWidget(mode);
    }

    @Override
    public void setWidgetVisible(boolean visible) {
        this.getWidget().setVisible(visible);
    }

    @Override
    public PresentationContext getCurrentPresentationContext() {
        return this.widgetAdapterManager.getCurrentPresentationContext();
    }

    @Override
    public Locale getContentLocale() {
        return this.widgetAdapterManager.getContentLocale();
    }

    @Override
    public void addScheduledTask(Runnable task) {
        for (IEditorPlayground singlePlayground : this.playgrounds) {
            singlePlayground.addScheduledTask(task);
        }
    }

    @Override
    public void removeScheduledTask(Runnable task) {
        for (IEditorPlayground singlePlayground : this.playgrounds) {
            singlePlayground.removeScheduledTask(task);
        }
    }

    @Override
    public void setCloseVeto(ITextProvider vetoMessage) {
        for (IEditorPlayground singlePlayground : this.playgrounds) {
            singlePlayground.addCloseVeto(this, vetoMessage);
        }
        this.updateWidgetMessageDisplay();
    }

    @Override
    public void unsetCloseVeto() {
        for (IEditorPlayground singlePlayground : this.playgrounds) {
            singlePlayground.removeCloseVeto(this);
        }
        this.updateWidgetMessageDisplay();
    }
}

