/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.playground;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.IPlaygroundManager;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IEditorMessageSet;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXPermissionDenied;
import com.arcway.lib.ui.editor.exception.EEXRelationCardinalityViolation;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.editor.playground.AbstractPlayground;
import com.arcway.lib.ui.editor.playground.IRelationPlayground;
import com.arcway.lib.ui.editor.playground.IRelationPlaygroundFactory;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IRelationWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.modelaccess.IModelAccess;
import java.util.Iterator;

public class RelationPlayground<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_REFERENCE>
extends AbstractPlayground<IRelationWidgetAdapter, PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE>
implements IRelationPlayground {
    private final IMapRW_<Object, IRelationPlayground> map_relationTypeID_subRelationPlayground;
    private IRelationPlayground superRelationPlayground;
    private final IMapRW_<Object, IMapRW_<Object, IEditorMessage>> map_roleID_objectID_error;
    private boolean isModificationLocked;
    private final Object relationTypeID;

    public RelationPlayground(Object relationTypeID, IEditorModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> modelAccessAgent, IPlaygroundManager playgroundManager) {
        super(modelAccessAgent, playgroundManager);
        this.relationTypeID = relationTypeID;
        this.map_relationTypeID_subRelationPlayground = new HashMap_(this.getContentReferenceInterpreter().getRelationTypeIDHasher());
        this.map_roleID_objectID_error = new HashMap_(this.getContentReferenceInterpreter().getRoleIDHasher());
    }

    @Override
    public void addSubRelationPlayground(Object relationTypeID_, IRelationPlayground relationPlayground) {
        this.map_relationTypeID_subRelationPlayground.put(relationTypeID_, (Object)relationPlayground);
    }

    @Override
    public void setSuperRelationPlayground(IRelationPlayground superRelationPlayground) {
        this.superRelationPlayground = superRelationPlayground;
    }

    private boolean isConcreteRelationPlayground() {
        return this.map_relationTypeID_subRelationPlayground.isEmpty();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void updateWidgetMessages() {
        try {
            for (IDataWidgetAdapter element : this.getWidgetAdapters()) {
                Object roleID = ((IRelationWidgetAdapter)element).getRoleID();
                Object objectID = ((IRelationWidgetAdapter)element).getObjectID();
                IEditorMessageSet contributionMessageSet = this.getCurrentModelAndModificationsAccessAgent().getRelationContributionMessages(this.relationTypeID, roleID, objectID);
                if (contributionMessageSet.isEmpty()) continue;
                this.setError(roleID, objectID, (IEditorMessage)contributionMessageSet.getMessages().get(0));
            }
        }
        catch (EEXNotReproducibleSnapshot eNRS) {
            this.setGlobalError(new PlaygroundError(eNRS));
        }
        for (IDataWidgetAdapter widgetAdapter : this.getWidgetAdapters()) {
            widgetAdapter.update(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE_IF_PLAYGROUND_VALUE_DIFFERS);
        }
    }

    public void addRelation(Object relationSample) {
        this.getCurrentModelAndModificationsAccessAgent().addNewRelation(this.relationTypeID, relationSample);
        this.getPlaygroundManager().playgroundDataChanged(false);
    }

    public void addRelation(Object objectID, Object roleID1, Object objectReference) {
        this.removeAllErrors();
        try {
            this.getLockAndPermissionProvider().checkPermissionForCreateOrDeleteRelation(this.relationTypeID, roleID1, objectID, objectReference);
            this.getCurrentModelAndModificationsAccessAgent().addNewRelation(this.relationTypeID, roleID1, objectID, objectReference);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID1, objectID, objectReference, new PlaygroundError(exNRS));
            return;
        }
        catch (EEXLockDenied e) {
            this.isModificationLocked = false;
            this.setLockMessageText(this.getMessageForException(e));
            this.setError(roleID1, objectID, objectReference, new PlaygroundError(e, this.getPlaygroundManager()));
            return;
        }
        catch (EEXPermissionDenied e) {
            this.setPermissionMessageText(this.getMessageForException(e));
            return;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID1, objectID, objectReference, new PlaygroundError(e));
            return;
        }
        this.getPlaygroundManager().playgroundDataChanged(false);
    }

    public IHasher_<Object> getRelationReferenceHasher() {
        return this.getContentReferenceInterpreter().getRelationReferenceHasher();
    }

    public String getLabel(Object objectID, Object roleID, Object relationRef) {
        try {
            return this.getCurrentModelAndModificationsAccessAgent().getLabelForRelation(this.relationTypeID, roleID, objectID, relationRef, this.getCurrentPresentationContext());
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(exNRS));
            return null;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(e));
            return null;
        }
    }

    public IEditorMessageSet getRelationContributionMessageSet(Object roleID, Object objectID) {
        try {
            return this.getCurrentModelAndModificationsAccessAgent().getRelationContributionMessages(this.relationTypeID, roleID, objectID);
        }
        catch (EEXNotReproducibleSnapshot e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
            return null;
        }
    }

    public String getLabelDecoration(Object objectID, Object roleID, Object relationRef) {
        try {
            return this.getCurrentModelAndModificationsAccessAgent().getLabelDecorationForRelation(this.relationTypeID, roleID, objectID, relationRef, this.getCurrentPresentationContext());
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(exNRS));
            return null;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(e));
            return null;
        }
    }

    public IStreamResource getIcon16x16(Object objectID, Object roleID, Object relationRef) {
        try {
            return this.getCurrentModelAndModificationsAccessAgent().getIconForRelation16x16(this.relationTypeID, roleID, objectID, relationRef, this.getCurrentPresentationContext());
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(exNRS));
            return null;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(e));
            return null;
        }
    }

    public IStreamResource getIconDecoration7x8(Object objectID, Object roleID, Object relationRef) {
        try {
            return this.getCurrentModelAndModificationsAccessAgent().getIconDecorationForRelation7x8(this.relationTypeID, roleID, objectID, relationRef);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(exNRS));
            return null;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(e));
            return null;
        }
    }

    public ITextProvider getToolTipText(Object roleID, Object objectID, Object relationRef) {
        try {
            return this.getCurrentModelAndModificationsAccessAgent().getToolTipTextForRelation(this.relationTypeID, roleID, objectID, relationRef);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(exNRS));
            return null;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(e));
            return null;
        }
    }

    @Override
    public void checkLock() throws EEXLockDenied {
        this.setLockMessageText(null);
        for (Object element : this.getWidgetAdapters()) {
            IRelationWidgetAdapter widgetAdapter = (IRelationWidgetAdapter)element;
            Object roleID = widgetAdapter.getRoleID();
            Object objectID = widgetAdapter.getObjectID();
            try {
                this.getLockAndPermissionProvider().acquireLockForCreateOrDeleteRelation(this.relationTypeID, roleID, objectID, null);
                this.isModificationLocked = true;
            }
            catch (EEXNotReproducibleSnapshot exNRS) {
                this.setError(roleID, objectID, new PlaygroundError(exNRS));
            }
            catch (EEXLockDenied e) {
                this.isModificationLocked = false;
                this.setLockMessageText(this.getMessageForException(e));
                throw e;
            }
            catch (EEXSnapshotClosed e) {
                this.setError(roleID, objectID, new PlaygroundError(e));
            }
        }
    }

    public IDataType getObjectReferenceCollectionDataType() {
        return this.getContentReferenceInterpreter().getObjectReferenceCollectionDataType();
    }

    public Object getParent(Object objectID, Object roleID, Object relationRef) {
        Object parent = null;
        try {
            parent = this.getCurrentModelAndModificationsAccessAgent().getParent(relationRef);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(e));
        }
        return parent;
    }

    public String getRelatedItemLocation(Object objectID, Object roleID, Object relationRef) {
        String relatedItemLocation = "";
        try {
            relatedItemLocation = this.getCurrentModelAndModificationsAccessAgent().getRelatedItemLocation(relationRef, this.getCurrentPresentationContext());
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, relationRef, new PlaygroundError(e));
        }
        return relatedItemLocation;
    }

    public ISet_<? extends Object> getRelationsThatMayBeDeleted(Object objectID, Object roleID, boolean relationsWithPermissionOnly) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getRelationsThatMayBeDeleted(this.relationTypeID, objectID, roleID, relationsWithPermissionOnly);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public ISet_<? extends Object> getRelationsThatMustBeDeleted(Object objectID, Object roleID) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getRelationsThatMustBeDeleted(this.relationTypeID, objectID, roleID);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public ISet_<? extends Object> getRelationsThatMustNotBeDeleted(Object objectID, Object roleID) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getRelationsThatMustNotBeDeleted(this.relationTypeID, objectID, roleID);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public ISet_<? extends Object> getRelationsThatMayBeCreated(Object objectID, Object roleID, boolean relationsWithPermissionOnly) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getRelationsThatMayBeCreated(this.relationTypeID, objectID, roleID, relationsWithPermissionOnly);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public ISet_<? extends Object> getRelationsThatAreRecommendedToBeCreated(Object objectID, Object roleID, boolean relationsWithPermissionOnly) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getRelationsThatAreRecommendedToBeCreated(this.relationTypeID, objectID, roleID, relationsWithPermissionOnly);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public ISet_<? extends Object> getRelationsThatMustBeCreated(Object objectID, Object roleID) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getRelationsThatMustBeCreated(this.relationTypeID, objectID, roleID);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public ISet_<? extends Object> getRelationsThatMustNotBeCreated(Object objectID, Object roleID) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getRelationsThatMustNotBeCreated(this.relationTypeID, objectID, roleID);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public ISet_<? extends Object> getCreatedRelations(Object objectID, Object roleID) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getCreatedRelations(this.relationTypeID, objectID, roleID);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public ISet_<? extends Object> getDeletedRelations(Object objectID, Object roleID) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getDeletedRelations(this.relationTypeID, objectID, roleID);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public ISet_<? extends Object> getCreatedAndNotDeletedRelations(Object objectID, Object roleID, boolean relationsWithPermissionOnly) {
        ISet_<Object> relations = null;
        try {
            relations = this.getCurrentModelAndModificationsAccessAgent().getCreatedAndNotDeletedRelations(this.relationTypeID, objectID, roleID, relationsWithPermissionOnly);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
        }
        return relations;
    }

    public int getMinCardinality(Object roleID) {
        return this.getCurrentModelAndModificationsAccessAgent().getMinCardinality(this.relationTypeID, roleID);
    }

    public int getMaxCardinality(Object roleID) {
        return this.getCurrentModelAndModificationsAccessAgent().getMaxCardinality(this.relationTypeID, roleID);
    }

    public boolean isRelationPossible(Object objectID, Object roleID, Object objectReference, boolean checkPermissionAndAcquireLock) throws EEXLockDenied {
        block5: {
            boolean isPossibleAccordingToSchemaAndModel = this.getCurrentModelAndModificationsAccessAgent().isRelationPossible(this.relationTypeID, roleID, objectID, objectReference);
            if (isPossibleAccordingToSchemaAndModel) break block5;
            return false;
        }
        try {
            if (checkPermissionAndAcquireLock) {
                this.getLockAndPermissionProvider().acquireLockForCreateOrDeleteRelation(this.relationTypeID, roleID, objectID, objectReference);
            }
            return true;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, objectReference, new PlaygroundError(e));
            return false;
        }
        catch (EEXNotReproducibleSnapshot e) {
            this.setError(roleID, objectID, objectReference, new PlaygroundError(e));
            return false;
        }
    }

    public ITextProvider getMessageForLockingException(EEXLockDenied eLD) {
        return this.getMessageForException(eLD);
    }

    @Override
    public void refreshPlayground() {
        this.updateChangeSetAccordingToNewCurrentState();
    }

    @Override
    public void releaseLock() {
        for (Object element : this.getWidgetAdapters()) {
            IRelationWidgetAdapter widgetAdapter = (IRelationWidgetAdapter)element;
            Object roleID = widgetAdapter.getRoleID();
            Object objectID = widgetAdapter.getObjectID();
            this.getLockAndPermissionProvider().releaseRelationLock(this.relationTypeID, roleID, objectID, null);
        }
        this.isModificationLocked = false;
    }

    public void removeRelation(Object objectID1, Object roleID1, Object objectReference) {
        this.removeAllErrors();
        try {
            this.getLockAndPermissionProvider().checkPermissionForCreateOrDeleteRelation(this.relationTypeID, roleID1, objectID1, objectReference);
            this.getCurrentModelAndModificationsAccessAgent().addDeletedRelation(this.relationTypeID, roleID1, objectID1, objectReference);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID1, objectID1, new PlaygroundError(exNRS));
            return;
        }
        catch (EEXLockDenied e) {
            this.isModificationLocked = false;
            this.setLockMessageText(this.getMessageForException(e));
            this.setError(roleID1, objectID1, objectReference, new PlaygroundError(e, this.getPlaygroundManager()));
            return;
        }
        catch (EEXPermissionDenied e) {
            this.setPermissionMessageText(this.getMessageForException(e));
            return;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID1, objectID1, objectReference, new PlaygroundError(e));
            return;
        }
        this.getPlaygroundManager().playgroundDataChanged(false);
    }

    @Override
    public boolean hasError() {
        return this.isConcreteRelationPlayground() && !this.map_roleID_objectID_error.isEmpty();
    }

    @Override
    public IEditorMessage getError() {
        if (this.isConcreteRelationPlayground()) {
            IEditorMessage highestError = null;
            for (IMapRW_ map_objectID_playgroundError : this.map_roleID_objectID_error.values()) {
                for (IEditorMessage error : map_objectID_playgroundError.values()) {
                    if (highestError != null && error.getMessageLevel().compareTo(highestError.getMessageLevel()) >= 0) continue;
                    highestError = error;
                }
            }
            return highestError;
        }
        return null;
    }

    @Override
    public boolean hasError(Object roleID, Object objectID) {
        if (this.isConcreteRelationPlayground()) {
            IMapRW_ map_objectID_error = (IMapRW_)this.map_roleID_objectID_error.getByKey(roleID);
            return map_objectID_error != null && map_objectID_error.containsKey(objectID);
        }
        for (IRelationPlayground subRelationPlayground : this.map_relationTypeID_subRelationPlayground.values()) {
            if (!subRelationPlayground.hasError(roleID, objectID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IEditorMessage getError(Object roleID, Object objectID) {
        if (this.isConcreteRelationPlayground()) {
            IMapRW_ map_objectID_error = (IMapRW_)this.map_roleID_objectID_error.getByKey(roleID);
            if (map_objectID_error != null) {
                return (IEditorMessage)map_objectID_error.getByKey(objectID);
            }
            return null;
        }
        IEditorMessage highestError = null;
        for (IRelationPlayground subRelationPlayground : this.map_relationTypeID_subRelationPlayground.values()) {
            IEditorMessage subPlaygroundError = subRelationPlayground.getError(roleID, objectID);
            if (subPlaygroundError == null || highestError != null && subPlaygroundError.getMessageLevel().compareTo(highestError.getMessageLevel()) >= 0) continue;
            highestError = subPlaygroundError;
        }
        return highestError;
    }

    @Override
    public void removeError() {
        if (this.isConcreteRelationPlayground()) {
            this.map_roleID_objectID_error.clear();
            this.getPlaygroundManager().removeError(this);
        }
    }

    @Override
    public void removeAllErrors() {
        if (this.isConcreteRelationPlayground()) {
            this.removeError();
        } else {
            for (IRelationPlayground subRelationPlayground : this.map_relationTypeID_subRelationPlayground.values()) {
                subRelationPlayground.removeAllErrors();
            }
        }
    }

    @Override
    @Deprecated
    public void setError(PlaygroundError playgroundError) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setError(Object roleID, Object objectID, Object relationRef, PlaygroundError error) {
        if (this.isConcreteRelationPlayground()) {
            this.putErrorIntoErrorMap(roleID, objectID, error);
        } else {
            Object concreteRelationTypeID = this.getContentReferenceInterpreter().getConcreteRelationTypeID(this.relationTypeID, roleID, objectID, relationRef);
            this.setError_internal(concreteRelationTypeID, roleID, objectID, relationRef, error);
        }
    }

    void setError_internal(Object concreteRelationTypeID, Object roleID, Object objectID, Object relationRef, PlaygroundError error) {
        IRelationPlayground subRelationPlayground = (IRelationPlayground)this.map_relationTypeID_subRelationPlayground.getByKey(concreteRelationTypeID);
        if (subRelationPlayground != null) {
            subRelationPlayground.setError(roleID, objectID, relationRef, error);
        } else {
            for (IRelationPlayground subRelationPlayground_ : this.map_relationTypeID_subRelationPlayground.values()) {
                ((RelationPlayground)subRelationPlayground_).setError_internal(concreteRelationTypeID, roleID, objectID, relationRef, error);
            }
        }
    }

    private void setGlobalError(PlaygroundError error) {
        for (IDataWidgetAdapter element : this.getWidgetAdapters()) {
            Object roleID = ((IRelationWidgetAdapter)element).getRoleID();
            Object objectID = ((IRelationWidgetAdapter)element).getObjectID();
            this.setError(roleID, objectID, error);
        }
    }

    void setError(Object roleID, Object objectID, IEditorMessage error) {
        if (this.isConcreteRelationPlayground()) {
            this.putErrorIntoErrorMap(roleID, objectID, error);
        } else {
            for (IRelationPlayground subRelationPlayground_ : this.map_relationTypeID_subRelationPlayground.values()) {
                ((RelationPlayground)subRelationPlayground_).setError(roleID, objectID, error);
            }
        }
    }

    private void putErrorIntoErrorMap(Object roleID, Object objectID, IEditorMessage error) {
        IMapRW_ map_objectID_error = (IMapRW_)this.map_roleID_objectID_error.getByKey(roleID);
        if (map_objectID_error == null) {
            map_objectID_error = new HashMap_(this.getContentReferenceInterpreter().getObjectIDHasher());
            this.map_roleID_objectID_error.put(roleID, (Object)map_objectID_error);
        }
        IEditorMessage currentError = (IEditorMessage)map_objectID_error.getByKey(objectID);
        if (error != null) {
            if (currentError == null || currentError.getMessageLevel().compareTo(error.getMessageLevel()) > 0) {
                map_objectID_error.put(objectID, (Object)error);
                this.getPlaygroundManager().errorInPlayground(this, error);
            }
        } else if (currentError != null && !currentError.getMessageLevel().isHigh()) {
            map_objectID_error.removeAsEntry(objectID);
        }
        if (map_objectID_error.isEmpty()) {
            this.map_roleID_objectID_error.removeAsEntry(roleID);
        }
    }

    @Override
    public boolean isModificationLocked() {
        return this.isModificationLocked;
    }

    @Override
    public boolean isModificationPermitted(Object objectID, Object roleID) {
        try {
            this.getLockAndPermissionProvider().checkPermissionForCreateOrDeleteRelation(this.relationTypeID, roleID, objectID);
            return true;
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(roleID, objectID, new PlaygroundError(exNRS));
            return false;
        }
        catch (EEXPermissionDenied e) {
            this.setPermissionMessageText(this.getMessageForException(e));
            return false;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(roleID, objectID, new PlaygroundError(e));
            return false;
        }
    }

    @Override
    public void updateAdapters(IWidgetAdapter initiatingWidgetAdapter) {
        this.updateSubAdapters(initiatingWidgetAdapter, false);
        this.updateOwnAdapters(initiatingWidgetAdapter);
        this.updateSuperAdapters(initiatingWidgetAdapter, false);
    }

    void updateSuperAdapters(IWidgetAdapter initiatingWidgetAdapter, boolean callOwnAdapters) {
        if (callOwnAdapters) {
            this.updateOwnAdapters(initiatingWidgetAdapter);
        }
        if (this.superRelationPlayground != null) {
            ((RelationPlayground)this.superRelationPlayground).updateSuperAdapters(initiatingWidgetAdapter, true);
        }
    }

    void updateSubAdapters(IWidgetAdapter initiatingWidgetAdapter, boolean callOwnAdapters) {
        for (IRelationPlayground subRelationPlayground : this.map_relationTypeID_subRelationPlayground.values()) {
            ((RelationPlayground)subRelationPlayground).updateSubAdapters(initiatingWidgetAdapter, true);
        }
        if (callOwnAdapters) {
            this.updateOwnAdapters(initiatingWidgetAdapter);
        }
    }

    private void updateOwnAdapters(IWidgetAdapter initiatingWidgetAdapter) {
        try {
            for (IDataWidgetAdapter element : this.getWidgetAdapters()) {
                Object roleID = ((IRelationWidgetAdapter)element).getRoleID();
                Object objectID = ((IRelationWidgetAdapter)element).getObjectID();
                try {
                    this.getCurrentModelAndModificationsAccessAgent().checkRelationCardinality(this.relationTypeID, roleID, objectID);
                }
                catch (EEXRelationCardinalityViolation eRCV) {
                    this.setError(roleID, objectID, new PlaygroundError(eRCV, this.getPlaygroundManager()));
                }
            }
        }
        catch (EEXSnapshotClosed eSC) {
            this.setGlobalError(new PlaygroundError(eSC));
        }
        catch (EEXNotReproducibleSnapshot eNRS) {
            this.setGlobalError(new PlaygroundError(eNRS));
        }
        this.sendUpdateSignalToAdapters(initiatingWidgetAdapter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean valueSet() {
        try {
            Object objectID;
            Object roleID;
            Iterator iterator = this.getWidgetAdapters().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                IDataWidgetAdapter widgetAdapter = (IDataWidgetAdapter)iterator.next();
                roleID = ((IRelationWidgetAdapter)widgetAdapter).getRoleID();
                objectID = ((IRelationWidgetAdapter)widgetAdapter).getObjectID();
            } while (!this.getCurrentModelAndModificationsAccessAgent().relationModified(this.relationTypeID, roleID, objectID));
            return true;
        }
        catch (EEXNotReproducibleSnapshot eNRS) {
            this.setGlobalError(new PlaygroundError(eNRS));
            return false;
        }
        catch (EEXSnapshotClosed eSC) {
            this.setGlobalError(new PlaygroundError(eSC));
        }
        return false;
    }

    private void updateChangeSetAccordingToNewCurrentState() {
        try {
            for (IDataWidgetAdapter widgetAdapter : this.getWidgetAdapters()) {
                Object roleID = ((IRelationWidgetAdapter)widgetAdapter).getRoleID();
                Object objectID = ((IRelationWidgetAdapter)widgetAdapter).getObjectID();
                this.getCurrentModelAndModificationsAccessAgent().updateRelationChangeSetsAccordingToNewCurrentState(this.relationTypeID, roleID, objectID);
            }
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setGlobalError(new PlaygroundError(exNRS));
            return;
        }
        catch (EEXSnapshotClosed e) {
            this.setGlobalError(new PlaygroundError(e));
            return;
        }
    }

    public static class PlaygroundFactory
    implements IRelationPlaygroundFactory {
        @Override
        public <PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_REFERENCE> IRelationPlayground createRelationPlayground(Object relationTypeID, IModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> modelAccessAgent, IPlaygroundManager playgroundManager) {
            return new RelationPlayground(relationTypeID, (IEditorModelAccess)modelAccessAgent, playgroundManager);
        }
    }
}

