/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.playground;

import com.arcway.lib.Messages;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.editor.IPlaygroundManager;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.exception.EEXRepositoryException;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;

public class PlaygroundError
implements IEditorMessage {
    private final IMessageLevel errorLevel;
    private final Exception cause;
    private final ITextProvider errorMessage;
    private final IStreamResource icon16x16;

    public PlaygroundError(IMessageLevel errorLevel, ITextProvider errorMessage) {
        assert (errorMessage != null);
        this.errorLevel = errorLevel;
        this.errorMessage = errorMessage;
        this.cause = null;
        this.icon16x16 = null;
    }

    public PlaygroundError(EEXRepositoryException cause, IPlaygroundManager playgroundManager) {
        if (cause instanceof EEXRepositoryAccessException) {
            EEXRepositoryAccessException typedCause = (EEXRepositoryAccessException)cause;
            this.errorLevel = playgroundManager.getErrorLevelForException(typedCause);
            this.icon16x16 = typedCause.getIcon16x16();
        } else {
            this.errorLevel = IMessageLevel.NORMAL;
            this.icon16x16 = null;
        }
        this.cause = cause;
        this.errorMessage = playgroundManager.getMessageForException(cause);
        assert (this.errorMessage != null);
    }

    public PlaygroundError(EEXSnapshotClosed cause) {
        this.errorLevel = IMessageLevel.NORMAL;
        this.icon16x16 = null;
        this.cause = cause;
        this.errorMessage = Messages.getTextProvider("PlaygroundError.SnapshotClosed", new String[0]);
    }

    public PlaygroundError(JvmExternalResourceInteractionException cause) {
        this.errorLevel = IMessageLevel.NORMAL;
        this.icon16x16 = null;
        this.cause = cause;
        this.errorMessage = Messages.getTextProvider("PlaygroundError.FileError", cause.getLocalizedMessage());
        assert (this.errorMessage != null);
    }

    public PlaygroundError(EEXNotReproducibleSnapshot cause) {
        this.errorLevel = IMessageLevel.NORMAL;
        this.icon16x16 = null;
        this.cause = cause;
        this.errorMessage = Messages.getTextProvider("PlaygroundError.SnapshotNotReproducible", new String[0]);
        assert (this.errorMessage != null);
    }

    public Exception getCause() {
        return this.cause;
    }

    @Override
    public IMessageLevel getMessageLevel() {
        return this.errorLevel;
    }

    @Override
    public String getMessageText(PresentationContext presentationContext) {
        return this.errorMessage == null ? null : this.errorMessage.getText(presentationContext);
    }

    @Override
    public IStreamResource getIcon16x16() {
        return this.icon16x16;
    }
}

