/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.manager;

import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.ui.editor.UITypeID;
import com.arcway.lib.ui.editor.datatype.IComplexWidgetFactory;
import com.arcway.lib.ui.editor.datatype.IComplexWidgetFactoryRegistration;
import com.arcway.lib.ui.editor.datatype.IDataWidgetFactory;
import com.arcway.lib.ui.editor.datatype.IDataWidgetFactoryRegistration;
import com.arcway.lib.ui.editor.datatype.ILayoutWidgetFactory;
import com.arcway.lib.ui.editor.datatype.ILayoutWidgetFactoryRegistration;
import com.arcway.lib.ui.editor.datatype.ITestWidgetFactory;
import com.arcway.lib.ui.editor.datatype.ITestWidgetFactoryRegistration;
import com.arcway.lib.ui.editor.datatype.IUITypeID;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.extensionpoints.ComplexWidgetFactoryExtensionPoint;
import com.arcway.lib.ui.editor.extensionpoints.DataWidgetFactoryExtensionPoint;
import com.arcway.lib.ui.editor.extensionpoints.LayoutWidgetFactoryExtensionPoint;
import com.arcway.lib.ui.editor.extensionpoints.TestWidgetFactoryExtensionPoint;
import java.util.HashMap;
import java.util.Map;

public class WidgetFactoryRegistry {
    private static WidgetFactoryRegistry INSTANCE = null;
    private final Map<WidgetFactoryKey, IDataWidgetFactory> dataWidgetFactoryRegistrationMap;
    private final Map<WidgetFactoryKey, ILayoutWidgetFactory> layoutWidgetFactoryRegistrationMap;
    private final Map<WidgetFactoryKey, IComplexWidgetFactory> complexWidgetFactoryRegistrationMap;
    private final IMapRW_<IWidgetTypeID, ITestWidgetFactory> testWidgetFactoryRegistrationMap;

    public static synchronized WidgetFactoryRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WidgetFactoryRegistry();
        }
        return INSTANCE;
    }

    public WidgetFactoryRegistry() {
        DataWidgetFactoryExtensionPoint extensionPoint = DataWidgetFactoryExtensionPoint.getInstance();
        ICollection_<IDataWidgetFactoryRegistration> widgetFactoryRegistrations = extensionPoint.getDataWidgetFactoryRegistrations();
        this.dataWidgetFactoryRegistrationMap = new HashMap<WidgetFactoryKey, IDataWidgetFactory>(widgetFactoryRegistrations.size() * 2);
        for (IDataWidgetFactoryRegistration registration : widgetFactoryRegistrations) {
            IDataWidgetFactory replacedValue = this.dataWidgetFactoryRegistrationMap.put(new WidgetFactoryKey(registration.getUITypeID(), registration.getWidgetTypeID()), registration.getDataWidgetFactory());
            assert (replacedValue == null);
        }
        LayoutWidgetFactoryExtensionPoint layoutWidgetFactoryExtensionPoint = LayoutWidgetFactoryExtensionPoint.getInstance();
        ICollection_<ILayoutWidgetFactoryRegistration> layoutWidgetFactoryRegistrations = layoutWidgetFactoryExtensionPoint.getLayoutWidgetFactoryRegistrations();
        this.layoutWidgetFactoryRegistrationMap = new HashMap<WidgetFactoryKey, ILayoutWidgetFactory>(layoutWidgetFactoryRegistrations.size() * 2);
        for (ILayoutWidgetFactoryRegistration registration : layoutWidgetFactoryRegistrations) {
            ILayoutWidgetFactory replacedValue = this.layoutWidgetFactoryRegistrationMap.put(new WidgetFactoryKey(registration.getUITypeID(), registration.getWidgetTypeID()), registration.getLayoutWidgetFactory());
            assert (replacedValue == null);
        }
        ComplexWidgetFactoryExtensionPoint portableWidgetFactoryExtensionPoint = ComplexWidgetFactoryExtensionPoint.getInstance();
        ICollection_<IComplexWidgetFactoryRegistration> portableWidgetFactoryRegistrations = portableWidgetFactoryExtensionPoint.getComplexWidgetFactoryRegistrations();
        this.complexWidgetFactoryRegistrationMap = new HashMap<WidgetFactoryKey, IComplexWidgetFactory>(portableWidgetFactoryRegistrations.size());
        for (IComplexWidgetFactoryRegistration registration : portableWidgetFactoryRegistrations) {
            IComplexWidgetFactory replacedValue = this.complexWidgetFactoryRegistrationMap.put(new WidgetFactoryKey(registration.getUITypeID(), registration.getWidgetTypeID()), registration.getComplexWidgetFactory());
            assert (replacedValue == null);
        }
        TestWidgetFactoryExtensionPoint testWidgetFactoryExtensionPoint = TestWidgetFactoryExtensionPoint.getInstance();
        ICollection_<ITestWidgetFactoryRegistration> testWidgetFactoryRegistrations = testWidgetFactoryExtensionPoint.getTestWidgetFactoryRegistrations();
        this.testWidgetFactoryRegistrationMap = new HashMap_(testWidgetFactoryRegistrations.size(), IWidgetTypeID.IS_EQUAL_WIDGET_TYPE_ID_HASHER);
        for (ITestWidgetFactoryRegistration registration : testWidgetFactoryRegistrations) {
            boolean mapDidAlreadyContainKey = this.testWidgetFactoryRegistrationMap.put((Object)registration.getWidgetTypeID(), (Object)registration.getTestWidgetFactory());
            assert (!mapDidAlreadyContainKey);
        }
    }

    public IDataWidgetFactory findDataWidgetFactory(IWidgetTypeID widgetTypeID, UITypeID uiTypeID) {
        return WidgetFactoryRegistry.findFactory(widgetTypeID, uiTypeID, this.dataWidgetFactoryRegistrationMap);
    }

    public ILayoutWidgetFactory findLayoutWidgetFactory(IWidgetTypeID widgetTypeID, UITypeID uiTypeID) {
        return WidgetFactoryRegistry.findFactory(widgetTypeID, uiTypeID, this.layoutWidgetFactoryRegistrationMap);
    }

    public IComplexWidgetFactory findComplexWidgetFactory(IWidgetTypeID widgetTypeID, UITypeID uiTypeID) {
        return WidgetFactoryRegistry.findFactory(widgetTypeID, uiTypeID, this.complexWidgetFactoryRegistrationMap);
    }

    public ITestWidgetFactory findTestWidgetFactory(IWidgetTypeID widgetTypeID) {
        return (ITestWidgetFactory)this.testWidgetFactoryRegistrationMap.getByKey((Object)widgetTypeID);
    }

    private static <FACTORY_TYPE> FACTORY_TYPE findFactory(IWidgetTypeID widgetTypeID, UITypeID uiTypeID, Map<WidgetFactoryKey, FACTORY_TYPE> factoryRegistrationMap) {
        FACTORY_TYPE factory = factoryRegistrationMap.get(new WidgetFactoryKey(uiTypeID, widgetTypeID));
        if (factory == null && !IUITypeID.IS_EQUAL_UI_TYPE_ID_HASHER.isEqual((Object)uiTypeID, (Object)IUITypeID.UI_TYPE_INDEPENDANT)) {
            factory = factoryRegistrationMap.get(new WidgetFactoryKey(IUITypeID.UI_TYPE_INDEPENDANT, widgetTypeID));
        }
        return factory;
    }

    private static class WidgetFactoryKey {
        private final IWidgetTypeID widgetTypeID;
        private final IUITypeID uiTypeID;
        private final int hashCode;

        public WidgetFactoryKey(IUITypeID uiTypeID, IWidgetTypeID widgetTypeID) {
            this.widgetTypeID = widgetTypeID;
            this.uiTypeID = uiTypeID;
            this.hashCode = IWidgetTypeID.IS_EQUAL_WIDGET_TYPE_ID_HASHER.getHashCode((Object)widgetTypeID);
        }

        public boolean equals(Object obj) {
            if (obj instanceof WidgetFactoryKey) {
                WidgetFactoryKey key = (WidgetFactoryKey)obj;
                return this.hashCode == key.hashCode && IWidgetTypeID.IS_EQUAL_WIDGET_TYPE_ID_HASHER.isEqual((Object)this.widgetTypeID, (Object)key.widgetTypeID) && IUITypeID.IS_EQUAL_UI_TYPE_ID_HASHER.isEqual((Object)this.uiTypeID, (Object)key.uiTypeID);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

