/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.manager;

import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.ui.editor.datatype.IWidgetAdapterFactory;
import com.arcway.lib.ui.editor.datatype.IWidgetAdapterFactoryRegistration;
import com.arcway.lib.ui.editor.datatype.IWidgetAdapterFactoryRegistration_adaptersWithFlexiblePlaygroundBinding;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.extensionpoints.WidgetAdapterFactoryExtensionPoint;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public class WidgetAdapterFactoryManager {
    private static WidgetAdapterFactoryManager INSTANCE = null;
    private final HashMap<WidgetAdapterFactoryKey, IWidgetAdapterFactory> widgetAdapterFactoryRegistrationMap;
    private final HashMap_<IWidgetTypeID, IWidgetAdapterFactory> widgetAdapterFactoryRegistrationMap_adaptersWithFlexiblePlaygroundBinding;

    public static WidgetAdapterFactoryManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WidgetAdapterFactoryManager();
        }
        return INSTANCE;
    }

    public WidgetAdapterFactoryManager() {
        WidgetAdapterFactoryExtensionPoint extensionPoint = WidgetAdapterFactoryExtensionPoint.getInstance();
        ICollection_<IWidgetAdapterFactoryRegistration> widgetAdapterFactoryRegistrations = extensionPoint.getWidgetAdapterFactoryRegistrations();
        this.widgetAdapterFactoryRegistrationMap = new HashMap(widgetAdapterFactoryRegistrations.size() * 2);
        for (IWidgetAdapterFactoryRegistration registration : widgetAdapterFactoryRegistrations) {
            String[] editorDataTypeIDs = registration.getEditorDataTypeIDs();
            assert (editorDataTypeIDs != null);
            IWidgetAdapterFactory replacedValue = this.widgetAdapterFactoryRegistrationMap.put(new WidgetAdapterFactoryKey(Arrays.asList(registration.getEditorDataTypeIDs()), registration.getWidgetTypeID()), registration.getWidgetAdapterFactory());
            assert (replacedValue == null);
        }
        this.widgetAdapterFactoryRegistrationMap_adaptersWithFlexiblePlaygroundBinding = new HashMap_(IWidgetTypeID.IS_EQUAL_WIDGET_TYPE_ID_HASHER);
        ICollection_<IWidgetAdapterFactoryRegistration_adaptersWithFlexiblePlaygroundBinding> widgetAdapterFactoryRegistrations_adaptersWithFlexiblePlaygroundBinding = extensionPoint.getWidgetAdapterFactoryRegistrations_adaptersWithFlexiblePlaygroundBinding();
        for (IWidgetAdapterFactoryRegistration_adaptersWithFlexiblePlaygroundBinding registration : widgetAdapterFactoryRegistrations_adaptersWithFlexiblePlaygroundBinding) {
            boolean keyAlreadyExists = this.widgetAdapterFactoryRegistrationMap_adaptersWithFlexiblePlaygroundBinding.put((Object)registration.getWidgetTypeID(), (Object)registration.getWidgetAdapterFactory());
            assert (!keyAlreadyExists);
        }
    }

    public IWidgetAdapterFactory findWidgetAdapterFactory(Collection<String> editorDataTypeIDs, IWidgetTypeID widgetTypeID) {
        IWidgetAdapterFactory widgetAdapterFactory = null;
        if (editorDataTypeIDs != null && !editorDataTypeIDs.isEmpty()) {
            widgetAdapterFactory = this.widgetAdapterFactoryRegistrationMap.get(new WidgetAdapterFactoryKey(editorDataTypeIDs, widgetTypeID));
        }
        if (widgetAdapterFactory == null) {
            widgetAdapterFactory = (IWidgetAdapterFactory)this.widgetAdapterFactoryRegistrationMap_adaptersWithFlexiblePlaygroundBinding.getByKey((Object)widgetTypeID);
        }
        return widgetAdapterFactory;
    }

    private static class WidgetAdapterFactoryKey {
        private final IWidgetTypeID widgetTypeID;
        private final String[] sortedEditorDataTypeIDs;
        private final int hashCode;

        public WidgetAdapterFactoryKey(Collection<String> editorDataTypeIDs, IWidgetTypeID widgetTypeID) {
            Object[] editorDataTypeIDArray;
            if (editorDataTypeIDs != null) {
                editorDataTypeIDArray = editorDataTypeIDs.toArray(new String[editorDataTypeIDs.size()]);
                if (editorDataTypeIDArray.length > 1) {
                    Arrays.sort(editorDataTypeIDArray);
                }
            } else {
                editorDataTypeIDArray = null;
            }
            this.widgetTypeID = widgetTypeID;
            this.sortedEditorDataTypeIDs = editorDataTypeIDArray;
            this.hashCode = IWidgetTypeID.IS_EQUAL_WIDGET_TYPE_ID_HASHER.getHashCode((Object)widgetTypeID);
        }

        public boolean equals(Object obj) {
            if (obj instanceof WidgetAdapterFactoryKey) {
                WidgetAdapterFactoryKey key2 = (WidgetAdapterFactoryKey)obj;
                return IWidgetTypeID.IS_EQUAL_WIDGET_TYPE_ID_HASHER.isEqual((Object)this.widgetTypeID, (Object)key2.widgetTypeID) && (this.sortedEditorDataTypeIDs == null || key2.sortedEditorDataTypeIDs == null || Arrays.equals(this.sortedEditorDataTypeIDs, key2.sortedEditorDataTypeIDs));
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

