/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.datatype;

import com.arcway.lib.icons.Decorators7x8;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;

class MessageLevel
implements IMessageLevel {
    private static final int LEVEL_HIGH = 4;
    private static final int LEVEL_NORMAL = 3;
    private static final int LEVEL_WARNING = 2;
    private static final int LEVEL_INFORMATION = 1;
    private final Integer level;

    public static IMessageLevel createHigh() {
        return new MessageLevel(4);
    }

    public static IMessageLevel createNormal() {
        return new MessageLevel(3);
    }

    public static IMessageLevel createWarning() {
        return new MessageLevel(2);
    }

    public static IMessageLevel createInformation() {
        return new MessageLevel(1);
    }

    private MessageLevel(int level) {
        this.level = level;
    }

    @Override
    public boolean isHigh() {
        return this.getLevel() == 4;
    }

    @Override
    public boolean isError() {
        return this.getLevel() == 4 || this.getLevel() == 3;
    }

    @Override
    public boolean isWarning() {
        return this.getLevel() == 2;
    }

    @Override
    public boolean isInformation() {
        return this.getLevel() == 1;
    }

    private int getLevel() {
        return this.level;
    }

    @Override
    public IStreamResource getIcon16x16() {
        IStreamResource icon16x16 = this.isInformation() ? Icons16x16.INFO : (this.isWarning() ? Icons16x16.WARNING : Icons16x16.ERROR);
        return icon16x16;
    }

    @Override
    public IStreamResource getDecorator7x8() {
        IStreamResource icon7x8 = this.isInformation() ? Decorators7x8.INFO : (this.isWarning() ? Decorators7x8.WARNING : Decorators7x8.ERROR);
        return icon7x8;
    }

    @Override
    public int compareTo(IMessageLevel o) {
        return this.level.compareTo(((MessageLevel)o).level);
    }

    public int hashCode() {
        return this.level.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IMessageLevel)) {
            return false;
        }
        MessageLevel ml = (MessageLevel)obj;
        return this.level.equals(ml.level);
    }

    @Override
    public boolean isHigherThanInformation() {
        return this.getLevel() > 1;
    }
}

