/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.datatype;

import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.exception.IMessage;
import java.util.List;

public class EditorErrorMessage
implements IMessage {
    private final int level;
    private final String text;
    private final IStreamResource icon16x16;

    public static final String compileLabels(List<String> labels) {
        StringBuilder textBuilder = new StringBuilder();
        for (String label : labels) {
            if (textBuilder.length() > 0) {
                textBuilder.append(", ");
            }
            textBuilder.append(label);
        }
        return textBuilder.toString();
    }

    public EditorErrorMessage(Tuple<List<String>, IEditorMessage> labelsAndMessage, PresentationContext presentationContext) {
        List labels = (List)labelsAndMessage.getT1();
        IEditorMessage error = (IEditorMessage)labelsAndMessage.getT2();
        StringBuilder textBuilder = new StringBuilder();
        textBuilder.append(EditorErrorMessage.compileLabels(labels));
        String textMessage = error.getMessageText(presentationContext);
        if (textMessage != null) {
            if (textBuilder.length() > 0) {
                textBuilder.append(": ");
            }
            textBuilder.append(textMessage);
        }
        this.text = textBuilder.toString();
        IMessageLevel editorErrorLevel = error.getMessageLevel();
        IStreamResource defaultIcon = editorErrorLevel.getIcon16x16();
        this.level = editorErrorLevel.isInformation() ? 4 : (editorErrorLevel.isWarning() ? 3 : 2);
        IStreamResource editorErrorIcon = error.getIcon16x16();
        this.icon16x16 = editorErrorIcon != null ? editorErrorIcon : defaultIcon;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public IStreamResource getIcon16x16() {
        return this.icon16x16;
    }
}

