/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.dialog.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TreeViewInput<T> {
    private final List<? extends T> rootObjects;
    private final Map<? extends T, List<? extends T>> parent2Children;
    private final Collection<Object> allObjects;

    public TreeViewInput(List<? extends T> rootObjects, Map<? extends T, List<? extends T>> parent2Children) {
        assert (rootObjects != null);
        assert (parent2Children != null);
        this.rootObjects = rootObjects;
        this.parent2Children = parent2Children;
        this.allObjects = new ArrayList<Object>();
        this.addObjectsRecursively(rootObjects);
    }

    private void addObjectsRecursively(Collection<?> objects) {
        this.allObjects.addAll(objects);
        for (Object object : objects) {
            this.addObjectsRecursively((Collection)this.parent2Children.get(object));
        }
    }

    public List<? extends T> getRootObjects() {
        return this.rootObjects;
    }

    public Map<? extends T, List<? extends T>> getParent2Children() {
        return this.parent2Children;
    }

    public Collection<?> getAllObjects() {
        return this.allObjects;
    }
}

