/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.dialog.imports;

import com.arcway.lib.Messages;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.dialog.IDialogController;
import com.arcway.lib.ui.dialog.imports.IImportDialog;
import com.arcway.lib.ui.dialog.imports.IImportDialogController;
import com.arcway.lib.ui.dialog.imports.IImportModelAccess;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.window.IShell;
import java.util.Collection;

public class ImportDialogController
implements IDialogController,
IImportDialogController {
    private final IShell window;
    private final IImportDialog dialog;
    private final IImportModelAccess modelAccess;

    public ImportDialogController(IShell window, IImportDialog dialog, IImportModelAccess modelAccess) {
        this.window = window;
        this.dialog = dialog;
        this.modelAccess = modelAccess;
    }

    @Override
    public void updateLocks() {
        try {
            this.updateLocksAndDisplayErrorMessage();
        }
        catch (EEXNotReproducibleSnapshot e) {
            this.dialog.handleEEXNotReproducibleSnapshot(e);
        }
        catch (EEXSnapshotClosed e) {
            this.dialog.snapshotClosed(e);
        }
    }

    private void updateLocksAndDisplayErrorMessage() throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        Collection<IModificationProblem> modificationProblems = this.modelAccess.updateLocks(this.getCurrentPresentationContext());
        PresentationContext presentationContext = this.getCurrentPresentationContext();
        if (!modificationProblems.isEmpty()) {
            String title = Messages.getString("ModelAccess.LocksDenied.Title", presentationContext.getLocale());
            String message = Messages.getString("ModelAccess.LocksDenied.Message", presentationContext.getLocale());
            this.getWindow().showModificationProblemsDialog(modificationProblems, title, message);
        } else {
            String title = Messages.getString("ModelAccess.LocksGranted.Title", presentationContext.getLocale());
            String message = Messages.getString("ModelAccess.LocksGranted.Message", presentationContext.getLocale());
            this.getWindow().showMessageDialog(4, title, message);
        }
    }

    @Override
    public void changeImportFlag(Object element, boolean checked) throws EEXNotReproducibleSnapshot {
        this.modelAccess.getCurrentModelAndModificationsAccessAgent().setImportFlag(element, checked);
    }

    @Override
    public boolean getImportFlag(Object importedObject) {
        return this.modelAccess.getCurrentModelAndModificationsAccessAgent().getImportFlag(importedObject);
    }

    @Override
    public void objectSelected(Object selectedElement) {
        this.dialog.topEditor(selectedElement);
    }

    private PresentationContext getCurrentPresentationContext() {
        return this.dialog.getCurrentPresentationContext();
    }

    private IShell getWindow() {
        return this.window;
    }
}

