/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.contextmenus;

import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.ui.contextmenus.ISelectionTranslationManager;
import com.arcway.lib.ui.contextmenus.ISelectionTranslator;
import com.arcway.lib.ui.contextmenus.SelectionTranslationExtensionPoint;
import java.util.HashMap;
import java.util.Map;

public class SelectionTranslationManager
implements ISelectionTranslationManager {
    private Map<Object, Map<Class<?>[], Object>> cache;
    private static SelectionTranslationManager INSTANCE = null;

    public static SelectionTranslationManager getSelectionTranslationManager() {
        if (INSTANCE == null) {
            INSTANCE = new SelectionTranslationManager();
        }
        return INSTANCE;
    }

    private SelectionTranslationManager() {
        this.resetSelectionTranslationCache();
    }

    @Override
    public void resetSelectionTranslationCache() {
        this.cache = new HashMap<Object, Map<Class<?>[], Object>>();
    }

    @Override
    public Object translate(Class<?>[] requiredTypes, Object item) {
        Map<Class<?>[], Object> map2;
        if (this.cache.containsKey(item) && (map2 = this.cache.get(item)).containsKey(requiredTypes)) {
            return map2.get(requiredTypes);
        }
        SelectionTranslationExtensionPoint extensionPoint = SelectionTranslationExtensionPoint.getInstance();
        ICollection_<ISelectionTranslator> translators = extensionPoint.getSelectionTranlators();
        for (ISelectionTranslator translator : translators) {
            Class<?> supportedSourceType = translator.getSourceType();
            Class<?> supportedDestinationType = translator.getDestinationType();
            if (!supportedSourceType.isInstance(item)) continue;
            Class<?>[] classArray = requiredTypes;
            int n = requiredTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object translatedItem;
                Class<?> element = classArray[n2];
                if (supportedDestinationType.isAssignableFrom(element) && (translatedItem = translator.translate(item)) != null && element.isAssignableFrom(translatedItem.getClass())) {
                    this.putIntoCache(item, requiredTypes, translatedItem);
                    return translatedItem;
                }
                ++n2;
            }
        }
        return null;
    }

    private void putIntoCache(Object item, Class<?>[] requiredTypes, Object translatedItem) {
        if (this.cache.containsKey(item)) {
            Map<Class<?>[], Object> map2 = this.cache.get(item);
            map2.put(requiredTypes, translatedItem);
        } else {
            HashMap<Class<?>[], Object> map2 = new HashMap<Class<?>[], Object>();
            this.cache.put(item, map2);
            map2.put(requiredTypes, translatedItem);
        }
    }
}

