/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.saveimage;

public class RowFilter {
    private static final int abs(int x) {
        return x < 0 ? -x : x;
    }

    protected static int subFilter(byte[] currRow, byte[] subFilteredRow, int bytesPerPixel, int bytesPerRow) {
        int badness = 0;
        int i = bytesPerPixel;
        while (i < bytesPerRow + bytesPerPixel) {
            int curr = currRow[i] & 0xFF;
            int left = currRow[i - bytesPerPixel] & 0xFF;
            int difference = curr - left;
            subFilteredRow[i] = (byte)difference;
            badness += RowFilter.abs(difference);
            ++i;
        }
        return badness;
    }

    protected static int upFilter(byte[] currRow, byte[] prevRow, byte[] upFilteredRow, int bytesPerPixel, int bytesPerRow) {
        int badness = 0;
        int i = bytesPerPixel;
        while (i < bytesPerRow + bytesPerPixel) {
            int curr = currRow[i] & 0xFF;
            int up = prevRow[i] & 0xFF;
            int difference = curr - up;
            upFilteredRow[i] = (byte)difference;
            badness += RowFilter.abs(difference);
            ++i;
        }
        return badness;
    }

    protected final int paethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = RowFilter.abs(p - a);
        int pb = RowFilter.abs(p - b);
        int pc = RowFilter.abs(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    public int filterRow(int colorType, byte[] currRow, byte[] prevRow, byte[][] scratchRows, int bytesPerRow, int bytesPerPixel) {
        int up;
        int left;
        int curr;
        int badness;
        if (colorType != 3) {
            System.arraycopy(currRow, bytesPerPixel, scratchRows[0], bytesPerPixel, bytesPerRow);
            return 0;
        }
        int[] filterBadness = new int[5];
        int i = 0;
        while (i < 5) {
            filterBadness[i] = Integer.MAX_VALUE;
            ++i;
        }
        int badness2 = 0;
        int i2 = bytesPerPixel;
        while (i2 < bytesPerRow + bytesPerPixel) {
            int curr2 = currRow[i2] & 0xFF;
            badness2 += curr2;
            ++i2;
        }
        filterBadness[0] = badness2;
        byte[] subFilteredRow = scratchRows[1];
        filterBadness[1] = badness = RowFilter.subFilter(currRow, subFilteredRow, bytesPerPixel, bytesPerRow);
        byte[] upFilteredRow = scratchRows[2];
        filterBadness[2] = badness = RowFilter.upFilter(currRow, prevRow, upFilteredRow, bytesPerPixel, bytesPerRow);
        byte[] averageFilteredRow = scratchRows[3];
        badness = 0;
        int i3 = bytesPerPixel;
        while (i3 < bytesPerRow + bytesPerPixel) {
            curr = currRow[i3] & 0xFF;
            left = currRow[i3 - bytesPerPixel] & 0xFF;
            up = prevRow[i3] & 0xFF;
            int difference = curr - (left + up) / 2;
            averageFilteredRow[i3] = (byte)difference;
            badness += RowFilter.abs(difference);
            ++i3;
        }
        filterBadness[3] = badness;
        byte[] paethFilteredRow = scratchRows[4];
        badness = 0;
        i3 = bytesPerPixel;
        while (i3 < bytesPerRow + bytesPerPixel) {
            curr = currRow[i3] & 0xFF;
            left = currRow[i3 - bytesPerPixel] & 0xFF;
            up = prevRow[i3] & 0xFF;
            int upleft = prevRow[i3 - bytesPerPixel] & 0xFF;
            int predictor = this.paethPredictor(left, up, upleft);
            int difference = curr - predictor;
            paethFilteredRow[i3] = (byte)difference;
            badness += RowFilter.abs(difference);
            ++i3;
        }
        filterBadness[4] = badness;
        int minBadness = filterBadness[0];
        int filterType = 0;
        i3 = 1;
        while (i3 < 5) {
            if (filterBadness[i3] < minBadness) {
                minBadness = filterBadness[i3];
                filterType = i3;
            }
            ++i3;
        }
        if (filterType == 0) {
            System.arraycopy(currRow, bytesPerPixel, scratchRows[0], bytesPerPixel, bytesPerRow);
        }
        return filterType;
    }
}

