/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.saveimage;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IPalette;
import com.arcway.lib.graphics.image.PixelData;
import com.arcway.lib.graphics.saveimage.IIOMetadata;
import java.util.ArrayList;

public class PNGMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "javax_imageio_png_1.0";
    protected static final String nativeMetadataFormatClassName = "com.sun.imageio.plugins.png.PNGMetadataFormat";
    public static final String[] IHDR_colorTypeNames;
    public static final int[] IHDR_numChannels;
    public static final String[] IHDR_bitDepths;
    public static final String[] IHDR_compressionMethodNames;
    public static final String[] IHDR_filterMethodNames;
    public static final String[] IHDR_interlaceMethodNames;
    public static final String[] iCCP_compressionMethodNames;
    public static final String[] zTXt_compressionMethodNames;
    public static final int PHYS_UNIT_UNKNOWN = 0;
    public static final int PHYS_UNIT_METER = 1;
    public static final String[] unitSpecifierNames;
    public static final String[] renderingIntentNames;
    public static final String[] colorSpaceTypeNames;
    public boolean IHDR_present;
    public int IHDR_width;
    public int IHDR_height;
    public int IHDR_bitDepth;
    public int IHDR_colorType;
    public int IHDR_compressionMethod;
    public int IHDR_filterMethod;
    public int IHDR_interlaceMethod;
    public boolean PLTE_present;
    public byte[] PLTE_red;
    public byte[] PLTE_green;
    public byte[] PLTE_blue;
    public int[] PLTE_order = null;
    public boolean bKGD_present;
    public int bKGD_colorType;
    public int bKGD_index;
    public int bKGD_gray;
    public int bKGD_red;
    public int bKGD_green;
    public int bKGD_blue;
    public boolean cHRM_present;
    public int cHRM_whitePointX;
    public int cHRM_whitePointY;
    public int cHRM_redX;
    public int cHRM_redY;
    public int cHRM_greenX;
    public int cHRM_greenY;
    public int cHRM_blueX;
    public int cHRM_blueY;
    public boolean gAMA_present;
    public int gAMA_gamma;
    public boolean hIST_present;
    public char[] hIST_histogram;
    public boolean iCCP_present;
    public String iCCP_profileName;
    public int iCCP_compressionMethod;
    public byte[] iCCP_compressedProfile;
    public ArrayList iTXt_keyword = new ArrayList();
    public ArrayList iTXt_compressionFlag = new ArrayList();
    public ArrayList iTXt_compressionMethod = new ArrayList();
    public ArrayList iTXt_languageTag = new ArrayList();
    public ArrayList iTXt_translatedKeyword = new ArrayList();
    public ArrayList iTXt_text = new ArrayList();
    public boolean pHYs_present;
    public int pHYs_pixelsPerUnitXAxis;
    public int pHYs_pixelsPerUnitYAxis;
    public int pHYs_unitSpecifier;
    public boolean sBIT_present;
    public int sBIT_colorType;
    public int sBIT_grayBits;
    public int sBIT_redBits;
    public int sBIT_greenBits;
    public int sBIT_blueBits;
    public int sBIT_alphaBits;
    public boolean sPLT_present;
    public String sPLT_paletteName;
    public int sPLT_sampleDepth;
    public int[] sPLT_red;
    public int[] sPLT_green;
    public int[] sPLT_blue;
    public int[] sPLT_alpha;
    public int[] sPLT_frequency;
    public boolean sRGB_present;
    public int sRGB_renderingIntent;
    public ArrayList tEXt_keyword = new ArrayList();
    public ArrayList tEXt_text = new ArrayList();
    public boolean tIME_present;
    public int tIME_year;
    public int tIME_month;
    public int tIME_day;
    public int tIME_hour;
    public int tIME_minute;
    public int tIME_second;
    public boolean tRNS_present;
    public int tRNS_colorType;
    public byte[] tRNS_alpha;
    public int tRNS_gray;
    public int tRNS_red;
    public int tRNS_green;
    public int tRNS_blue;
    public ArrayList zTXt_keyword = new ArrayList();
    public ArrayList zTXt_compressionMethod = new ArrayList();
    public ArrayList zTXt_text = new ArrayList();
    public ArrayList unknownChunkType = new ArrayList();
    public ArrayList unknownChunkData = new ArrayList();

    static {
        String[] stringArray = new String[7];
        stringArray[0] = "Grayscale";
        stringArray[2] = "RGB";
        stringArray[3] = "Palette";
        stringArray[4] = "GrayAlpha";
        stringArray[6] = "RGBAlpha";
        IHDR_colorTypeNames = stringArray;
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[2] = 3;
        nArray[3] = 3;
        nArray[4] = 2;
        nArray[6] = 4;
        IHDR_numChannels = nArray;
        IHDR_bitDepths = new String[]{"1", "2", "4", "8", "16"};
        IHDR_compressionMethodNames = new String[]{"deflate"};
        IHDR_filterMethodNames = new String[]{"adaptive"};
        IHDR_interlaceMethodNames = new String[]{"none", "adam7"};
        iCCP_compressionMethodNames = new String[]{"deflate"};
        zTXt_compressionMethodNames = new String[]{"deflate"};
        unitSpecifierNames = new String[]{"unknown", "meter"};
        renderingIntentNames = new String[]{"Perceptual", "Relative colorimetric", "Saturation", "Absolute colorimetric"};
        String[] stringArray2 = new String[7];
        stringArray2[0] = "GRAY";
        stringArray2[2] = "RGB";
        stringArray2[3] = "RGB";
        stringArray2[4] = "GRAY";
        stringArray2[6] = "RGB";
        colorSpaceTypeNames = stringArray2;
    }

    public void initialize(IImageData imageType) {
        int numBands = this.getNumBands(imageType);
        IPalette paletteData = imageType.getPalette();
        int[] sampleSize = this.getSampleSize(imageType);
        int bitDepth = sampleSize[0];
        int i = 1;
        while (i < sampleSize.length) {
            if (sampleSize[i] > bitDepth) {
                bitDepth = sampleSize[i];
            }
            ++i;
        }
        if (sampleSize.length > 1 && bitDepth < 8) {
            bitDepth = 8;
        }
        if (bitDepth > 2 && bitDepth < 4) {
            bitDepth = 4;
        } else if (bitDepth > 4 && bitDepth < 8) {
            bitDepth = 8;
        } else if (bitDepth > 8 && bitDepth < 16) {
            bitDepth = 16;
        } else if (bitDepth > 16) {
            throw new RuntimeException("bitDepth > 16!");
        }
        this.IHDR_bitDepth = bitDepth;
        if (numBands == 1) {
            this.IHDR_colorType = 0;
        } else if (numBands == 2) {
            this.IHDR_colorType = 4;
        } else if (numBands == 3) {
            this.IHDR_colorType = 2;
        } else if (numBands == 4) {
            this.IHDR_colorType = 6;
        } else {
            throw new RuntimeException("Number of bands not 1-4!");
        }
        this.IHDR_present = true;
    }

    public int getNumBands(IImageData imageData) {
        int numBands;
        IPalette palette = imageData.getPalette();
        if (palette == null) {
            PixelData bitDepth = imageData.getBitDepth();
            numBands = 0;
            if (bitDepth.r > 0) {
                ++numBands;
            }
            if (bitDepth.g > 0) {
                ++numBands;
            }
            if (bitDepth.b > 0) {
                ++numBands;
            }
            if (bitDepth.alpha > 0) {
                ++numBands;
            }
        } else {
            PixelData bitDepth = imageData.getBitDepth();
            numBands = bitDepth.alpha > 0 ? 4 : 3;
        }
        return numBands;
    }

    public int[] getSampleSize(IImageData imageData) {
        IPalette palette = imageData.getPalette();
        PixelData bitDepth = imageData.getBitDepth();
        int[] sampleSize = new int[this.getNumBands(imageData)];
        if (palette == null) {
            int band = 0;
            if (bitDepth.r > 0) {
                sampleSize[band] = bitDepth.r;
                ++band;
            }
            if (bitDepth.g > 0) {
                sampleSize[band] = bitDepth.g;
                ++band;
            }
            if (bitDepth.b > 0) {
                sampleSize[band] = bitDepth.b;
                ++band;
            }
            if (bitDepth.alpha > 0) {
                sampleSize[band] = bitDepth.alpha;
                ++band;
            }
        } else {
            int band = 0;
            sampleSize[band] = 8;
            sampleSize[++band] = 8;
            sampleSize[++band] = 8;
            ++band;
            if (bitDepth.alpha > 0) {
                sampleSize[band] = bitDepth.alpha;
                ++band;
            }
        }
        return sampleSize;
    }

    public void getPixels(IImageData imageData, int x, int y, int w, int h, int[] iArray) {
        Color[] paletteColors = null;
        IPalette palette = imageData.getPalette();
        if (palette != null) {
            paletteColors = palette.getColors();
        }
        PixelData bitDepth = imageData.getBitDepth();
        PixelData pixelData = new PixelData();
        int t = 0;
        int iy = y;
        while (iy < y + h) {
            int ix = x;
            while (ix < x + w) {
                imageData.getPixel(ix, iy, pixelData);
                if (paletteColors == null) {
                    if (bitDepth.r > 0) {
                        iArray[t] = pixelData.r;
                        ++t;
                    }
                    if (bitDepth.g > 0) {
                        iArray[t] = pixelData.g;
                        ++t;
                    }
                    if (bitDepth.b > 0) {
                        iArray[t] = pixelData.b;
                        ++t;
                    }
                    if (bitDepth.alpha > 0) {
                        iArray[t] = pixelData.alpha;
                        ++t;
                    }
                } else {
                    int b;
                    int g;
                    int r;
                    int colorIndex = pixelData.colorIndex;
                    if (colorIndex == -1) {
                        r = 255;
                        g = 255;
                        b = 255;
                    } else {
                        Color pixelColor = paletteColors[colorIndex];
                        r = pixelColor.r;
                        g = pixelColor.g;
                        b = pixelColor.b;
                    }
                    iArray[t] = r;
                    iArray[++t] = g;
                    iArray[++t] = b;
                    ++t;
                    if (bitDepth.alpha > 0) {
                        iArray[t] = pixelData.alpha;
                        ++t;
                    }
                }
                ++ix;
            }
            ++iy;
        }
    }
}

