/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.saveimage;

import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.saveimage.ChunkStream;
import com.arcway.lib.graphics.saveimage.IDATOutputStream;
import com.arcway.lib.graphics.saveimage.IIOException;
import com.arcway.lib.graphics.saveimage.ImageOutputStream;
import com.arcway.lib.graphics.saveimage.ImageWriter;
import com.arcway.lib.graphics.saveimage.PNGImageReader;
import com.arcway.lib.graphics.saveimage.PNGMetadata;
import com.arcway.lib.graphics.saveimage.RowFilter;
import com.arcway.lib.java.To;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;

public class PNGImageWriter
extends ImageWriter {
    ImageOutputStream stream = null;
    PNGMetadata metadata = null;
    int sourceXOffset = 0;
    int sourceYOffset = 0;
    int sourceWidth = 0;
    int sourceHeight = 0;
    int periodX = 1;
    int periodY = 1;
    int numBands;
    int bpp;
    RowFilter rowFilter = new RowFilter();
    byte[] prevRow = null;
    byte[] currRow = null;
    byte[][] filteredRows = null;
    int[] sampleSize = null;
    int scalingBitDepth = -1;
    byte[][] scale = null;
    byte[] scale0 = null;
    byte[][] scaleh = null;
    byte[][] scalel = null;

    @Override
    public void setOutput(ImageOutputStream output) {
        super.setOutput(output);
        this.stream = output;
    }

    private void write_magic() throws IOException {
        byte[] magic = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.stream.write(magic);
    }

    private void write_IHDR() throws IOException {
        ChunkStream cs = new ChunkStream(PNGImageReader.IHDR_TYPE, this.stream);
        cs.writeInt(this.metadata.IHDR_width);
        cs.writeInt(this.metadata.IHDR_height);
        cs.writeByte(this.metadata.IHDR_bitDepth);
        cs.writeByte(this.metadata.IHDR_colorType);
        if (this.metadata.IHDR_compressionMethod != 0) {
            throw new IIOException("Only compression method 0 is defined in PNG 1.1");
        }
        cs.writeByte(this.metadata.IHDR_compressionMethod);
        if (this.metadata.IHDR_filterMethod != 0) {
            throw new IIOException("Only filter method 0 is defined in PNG 1.1");
        }
        cs.writeByte(this.metadata.IHDR_filterMethod);
        if (this.metadata.IHDR_interlaceMethod < 0 || this.metadata.IHDR_interlaceMethod > 1) {
            throw new IIOException("Only interlace methods 0 (node) and 1 (adam7) are defined in PNG 1.1");
        }
        cs.writeByte(this.metadata.IHDR_interlaceMethod);
        cs.finish();
    }

    private void write_cHRM() throws IOException {
        if (this.metadata.cHRM_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.cHRM_TYPE, this.stream);
            cs.writeInt(this.metadata.cHRM_whitePointX);
            cs.writeInt(this.metadata.cHRM_whitePointY);
            cs.writeInt(this.metadata.cHRM_redX);
            cs.writeInt(this.metadata.cHRM_redY);
            cs.writeInt(this.metadata.cHRM_greenX);
            cs.writeInt(this.metadata.cHRM_greenY);
            cs.writeInt(this.metadata.cHRM_blueX);
            cs.writeInt(this.metadata.cHRM_blueY);
            cs.finish();
        }
    }

    private void write_gAMA() throws IOException {
        if (this.metadata.gAMA_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.gAMA_TYPE, this.stream);
            cs.writeInt(this.metadata.gAMA_gamma);
            cs.finish();
        }
    }

    private void write_iCCP() throws IOException {
        if (this.metadata.iCCP_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.iCCP_TYPE, this.stream);
            cs.writeBytes(this.metadata.iCCP_profileName);
            cs.writeByte(0);
            cs.writeByte(this.metadata.iCCP_compressionMethod);
            cs.write(this.metadata.iCCP_compressedProfile);
            cs.finish();
        }
    }

    private void write_sBIT() throws IOException {
        if (this.metadata.sBIT_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.sBIT_TYPE, this.stream);
            int colorType = this.metadata.IHDR_colorType;
            if (this.metadata.sBIT_colorType != colorType) {
                this.processWarningOccurred("sBIT metadata has wrong color type.\nThe chunk will not be written.");
                return;
            }
            if (colorType == 0 || colorType == 4) {
                cs.writeByte(this.metadata.sBIT_grayBits);
            } else if (colorType == 2 || colorType == 3 || colorType == 6) {
                cs.writeByte(this.metadata.sBIT_redBits);
                cs.writeByte(this.metadata.sBIT_greenBits);
                cs.writeByte(this.metadata.sBIT_blueBits);
            }
            if (colorType == 4 || colorType == 6) {
                cs.writeByte(this.metadata.sBIT_alphaBits);
            }
            cs.finish();
        }
    }

    private void write_sRGB() throws IOException {
        if (this.metadata.sRGB_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.sRGB_TYPE, this.stream);
            cs.writeByte(this.metadata.sRGB_renderingIntent);
            cs.finish();
        }
    }

    private void write_PLTE() throws IOException {
        if (this.metadata.PLTE_present) {
            if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
                this.processWarningOccurred("A PLTE chunk may not appear in a gray or gray alpha image.\nThe chunk will not be written");
                return;
            }
            ChunkStream cs = new ChunkStream(PNGImageReader.PLTE_TYPE, this.stream);
            int numEntries = this.metadata.PLTE_red.length;
            byte[] palette = new byte[numEntries * 3];
            int index = 0;
            int i = 0;
            while (i < numEntries) {
                palette[index++] = this.metadata.PLTE_red[i];
                palette[index++] = this.metadata.PLTE_green[i];
                palette[index++] = this.metadata.PLTE_blue[i];
                ++i;
            }
            cs.write(palette);
            cs.finish();
        }
    }

    private void write_hIST() throws IOException, IIOException {
        if (this.metadata.hIST_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.hIST_TYPE, this.stream);
            if (!this.metadata.PLTE_present) {
                throw new IIOException("hIST chunk without PLTE chunk!");
            }
            cs.writeChars(this.metadata.hIST_histogram, 0, this.metadata.hIST_histogram.length);
            cs.finish();
        }
    }

    private void write_tRNS() throws IOException, IIOException {
        if (this.metadata.tRNS_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.tRNS_TYPE, this.stream);
            int colorType = this.metadata.IHDR_colorType;
            int chunkType = this.metadata.tRNS_colorType;
            int chunkRed = this.metadata.tRNS_red;
            int chunkGreen = this.metadata.tRNS_green;
            int chunkBlue = this.metadata.tRNS_blue;
            if (colorType == 2 && chunkType == 0) {
                chunkType = colorType;
                chunkGreen = chunkBlue = this.metadata.tRNS_gray;
                chunkRed = chunkBlue;
            }
            if (chunkType != colorType) {
                this.processWarningOccurred("tRNS metadata has incompatible color type.\nThe chunk will not be written.");
                return;
            }
            if (colorType == 3) {
                if (!this.metadata.PLTE_present) {
                    throw new IIOException("tRNS chunk without PLTE chunk!");
                }
                cs.write(this.metadata.tRNS_alpha);
            } else if (colorType == 0) {
                cs.writeShort(this.metadata.tRNS_gray);
            } else if (colorType == 2) {
                cs.writeShort(chunkRed);
                cs.writeShort(chunkGreen);
                cs.writeShort(chunkBlue);
            } else {
                throw new IIOException("tRNS chunk for color type 4 or 6!");
            }
            cs.finish();
        }
    }

    private void write_bKGD() throws IOException {
        if (this.metadata.bKGD_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.bKGD_TYPE, this.stream);
            int colorType = this.metadata.IHDR_colorType & 3;
            int chunkType = this.metadata.bKGD_colorType;
            int chunkRed = this.metadata.bKGD_red;
            int chunkGreen = this.metadata.bKGD_red;
            int chunkBlue = this.metadata.bKGD_red;
            if (colorType == 2 && chunkType == 0) {
                chunkType = colorType;
                chunkGreen = chunkBlue = this.metadata.bKGD_gray;
                chunkRed = chunkBlue;
            }
            if (chunkType != colorType) {
                this.processWarningOccurred("bKGD metadata has incompatible color type.\nThe chunk will not be written.");
                return;
            }
            if (colorType == 3) {
                cs.writeByte(this.metadata.bKGD_index);
            } else if (colorType == 0 || colorType == 4) {
                cs.writeShort(this.metadata.bKGD_gray);
            } else {
                cs.writeShort(chunkRed);
                cs.writeShort(chunkGreen);
                cs.writeShort(chunkBlue);
            }
            cs.finish();
        }
    }

    private void write_pHYs() throws IOException {
        if (this.metadata.pHYs_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.pHYs_TYPE, this.stream);
            cs.writeInt(this.metadata.pHYs_pixelsPerUnitXAxis);
            cs.writeInt(this.metadata.pHYs_pixelsPerUnitYAxis);
            cs.writeByte(this.metadata.pHYs_unitSpecifier);
            cs.finish();
        }
    }

    private void write_sPLT() throws IOException {
        if (this.metadata.sPLT_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.sPLT_TYPE, this.stream);
            cs.writeBytes(this.metadata.sPLT_paletteName);
            cs.writeByte(0);
            cs.writeByte(this.metadata.sPLT_sampleDepth);
            int numEntries = this.metadata.sPLT_red.length;
            if (this.metadata.sPLT_sampleDepth == 8) {
                int i = 0;
                while (i < numEntries) {
                    cs.writeByte(this.metadata.sPLT_red[i]);
                    cs.writeByte(this.metadata.sPLT_green[i]);
                    cs.writeByte(this.metadata.sPLT_blue[i]);
                    cs.writeByte(this.metadata.sPLT_alpha[i]);
                    cs.writeShort(this.metadata.sPLT_frequency[i]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < numEntries) {
                    cs.writeShort(this.metadata.sPLT_red[i]);
                    cs.writeShort(this.metadata.sPLT_green[i]);
                    cs.writeShort(this.metadata.sPLT_blue[i]);
                    cs.writeShort(this.metadata.sPLT_alpha[i]);
                    cs.writeShort(this.metadata.sPLT_frequency[i]);
                    ++i;
                }
            }
            cs.finish();
        }
    }

    private void write_tIME() throws IOException {
        if (this.metadata.tIME_present) {
            ChunkStream cs = new ChunkStream(PNGImageReader.tIME_TYPE, this.stream);
            cs.writeShort(this.metadata.tIME_year);
            cs.writeByte(this.metadata.tIME_month);
            cs.writeByte(this.metadata.tIME_day);
            cs.writeByte(this.metadata.tIME_hour);
            cs.writeByte(this.metadata.tIME_minute);
            cs.writeByte(this.metadata.tIME_second);
            cs.finish();
        }
    }

    private void write_tEXt() throws IOException {
        Iterator keywordIter = this.metadata.tEXt_keyword.iterator();
        Iterator textIter = this.metadata.tEXt_text.iterator();
        while (keywordIter.hasNext()) {
            ChunkStream cs = new ChunkStream(PNGImageReader.tEXt_TYPE, this.stream);
            String keyword = (String)keywordIter.next();
            cs.writeBytes(keyword);
            cs.writeByte(0);
            String text = (String)textIter.next();
            cs.writeBytes(text);
            cs.finish();
        }
    }

    private byte[] deflate(String s) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(baos);
        int len = s.length();
        int i = 0;
        while (i < len) {
            dos.write(To.toInt((char)s.charAt(i)));
            ++i;
        }
        dos.close();
        return baos.toByteArray();
    }

    private void write_iTXt() throws IOException {
        Iterator keywordIter = this.metadata.iTXt_keyword.iterator();
        Iterator flagIter = this.metadata.iTXt_compressionFlag.iterator();
        Iterator methodIter = this.metadata.iTXt_compressionMethod.iterator();
        Iterator languageIter = this.metadata.iTXt_languageTag.iterator();
        Iterator translatedKeywordIter = this.metadata.iTXt_translatedKeyword.iterator();
        Iterator textIter = this.metadata.iTXt_text.iterator();
        while (keywordIter.hasNext()) {
            ChunkStream cs = new ChunkStream(PNGImageReader.iTXt_TYPE, this.stream);
            String keyword = (String)keywordIter.next();
            cs.writeBytes(keyword);
            cs.writeByte(0);
            int flag = (Integer)flagIter.next();
            cs.writeByte(flag);
            int method = (Integer)methodIter.next();
            cs.writeByte(method);
            String languageTag = (String)languageIter.next();
            cs.writeBytes(languageTag);
            cs.writeByte(0);
            String translatedKeyword = (String)translatedKeywordIter.next();
            cs.writeBytes(translatedKeyword);
            cs.writeByte(0);
            String text = (String)textIter.next();
            if (flag == 1) {
                cs.write(this.deflate(text));
            } else {
                cs.writeUTF(text);
            }
            cs.finish();
        }
    }

    private void write_zTXt() throws IOException {
        Iterator keywordIter = this.metadata.zTXt_keyword.iterator();
        Iterator methodIter = this.metadata.zTXt_compressionMethod.iterator();
        Iterator textIter = this.metadata.zTXt_text.iterator();
        while (keywordIter.hasNext()) {
            ChunkStream cs = new ChunkStream(PNGImageReader.zTXt_TYPE, this.stream);
            String keyword = (String)keywordIter.next();
            cs.writeBytes(keyword);
            cs.writeByte(0);
            int compressionMethod = (Integer)methodIter.next();
            cs.writeByte(compressionMethod);
            String text = (String)textIter.next();
            cs.write(this.deflate(text));
            cs.finish();
        }
    }

    private void writeUnknownChunks() throws IOException {
        Iterator typeIter = this.metadata.unknownChunkType.iterator();
        Iterator dataIter = this.metadata.unknownChunkData.iterator();
        while (typeIter.hasNext() && dataIter.hasNext()) {
            String type = (String)typeIter.next();
            ChunkStream cs = new ChunkStream(PNGImageReader.chunkType(type), this.stream);
            byte[] data = (byte[])dataIter.next();
            cs.write(data);
            cs.finish();
        }
    }

    private void encodePass(ImageOutputStream os, IImageData image, int xOffset, int yOffset, int xSkip, int ySkip) throws IOException {
        int xOffsetTemp = xOffset;
        int xSkipTemp = xSkip;
        int yOffsetTemp = yOffset;
        int ySkipTemp = ySkip;
        int minX = this.sourceXOffset;
        int minY = this.sourceYOffset;
        int width = this.sourceWidth;
        int height = this.sourceHeight;
        int hpixels = (width - (xOffsetTemp *= this.periodX) + (xSkipTemp *= this.periodX) - 1) / xSkipTemp;
        int vpixels = (height - (yOffsetTemp *= this.periodY) + (ySkipTemp *= this.periodY) - 1) / ySkipTemp;
        if (hpixels == 0 || vpixels == 0) {
            return;
        }
        xOffsetTemp *= this.numBands;
        xSkipTemp *= this.numBands;
        int samplesPerByte = 8 / this.metadata.IHDR_bitDepth;
        int numSamples = width * this.numBands;
        int[] samples = new int[numSamples];
        int bytesPerRow = hpixels * this.numBands;
        if (this.metadata.IHDR_bitDepth < 8) {
            bytesPerRow = (bytesPerRow + samplesPerByte - 1) / samplesPerByte;
        } else if (this.metadata.IHDR_bitDepth == 16) {
            bytesPerRow *= 2;
        }
        this.currRow = new byte[bytesPerRow + this.bpp];
        this.prevRow = new byte[bytesPerRow + this.bpp];
        this.filteredRows = new byte[5][bytesPerRow + this.bpp];
        int bitDepth = this.metadata.IHDR_bitDepth;
        int row = minY + yOffsetTemp;
        while (row < minY + height) {
            this.metadata.getPixels(image, minX, row, width, 1, samples);
            int[] paletteOrder = this.metadata.PLTE_order;
            if (paletteOrder != null) {
                int i = 0;
                while (i < numSamples) {
                    samples[i] = paletteOrder[samples[i]];
                    ++i;
                }
            }
            int count = this.bpp;
            int pos = 0;
            int tmp = 0;
            switch (bitDepth) {
                case 1: 
                case 2: 
                case 4: {
                    int mask = samplesPerByte - 1;
                    int s = xOffsetTemp;
                    while (s < numSamples) {
                        byte val = this.scale0[samples[s]];
                        tmp = tmp << bitDepth | val;
                        if ((pos++ & mask) == mask) {
                            this.currRow[count++] = (byte)tmp;
                            tmp = 0;
                            pos = 0;
                        }
                        s += xSkipTemp;
                    }
                    if ((pos & mask) == 0) break;
                    this.currRow[count++] = (byte)(tmp <<= (8 / bitDepth - pos) * bitDepth);
                    break;
                }
                case 8: {
                    int b;
                    if (this.numBands == 1) {
                        int s = xOffsetTemp;
                        while (s < numSamples) {
                            this.currRow[count++] = this.scale0[samples[s]];
                            s += xSkipTemp;
                        }
                    } else {
                        int s = xOffsetTemp;
                        while (s < numSamples) {
                            b = 0;
                            while (b < this.numBands) {
                                this.currRow[count++] = this.scale[b][samples[s + b]];
                                ++b;
                            }
                            s += xSkipTemp;
                        }
                    }
                    break;
                }
                case 16: {
                    int b;
                    int s = xOffsetTemp;
                    while (s < numSamples) {
                        b = 0;
                        while (b < this.numBands) {
                            this.currRow[count++] = this.scaleh[b][samples[s + b]];
                            this.currRow[count++] = this.scalel[b][samples[s + b]];
                            ++b;
                        }
                        s += xSkipTemp;
                    }
                    break;
                }
            }
            int filterType = this.rowFilter.filterRow(this.metadata.IHDR_colorType, this.currRow, this.prevRow, this.filteredRows, bytesPerRow, this.bpp);
            os.write(filterType);
            os.write(this.filteredRows[filterType], this.bpp, bytesPerRow);
            byte[] swap = this.currRow;
            this.currRow = this.prevRow;
            this.prevRow = swap;
            row += ySkipTemp;
        }
    }

    private void write_IDAT(IImageData image) throws IOException {
        IDATOutputStream ios = new IDATOutputStream(this.stream, 32768);
        if (this.metadata.IHDR_interlaceMethod == 1) {
            int i = 0;
            while (i < 7) {
                this.encodePass(ios, image, PNGImageReader.adam7XOffset[i], PNGImageReader.adam7YOffset[i], PNGImageReader.adam7XSubsampling[i], PNGImageReader.adam7YSubsampling[i]);
                ++i;
            }
        } else {
            this.encodePass(ios, image, 0, 0, 1, 1);
        }
        ios.finish();
    }

    private void writeIEND() throws IOException {
        ChunkStream cs = new ChunkStream(PNGImageReader.IEND_TYPE, this.stream);
        cs.finish();
    }

    private boolean equals(int[] s0, int[] s1) {
        if (s0 == null || s1 == null) {
            return false;
        }
        if (s0.length != s1.length) {
            return false;
        }
        int i = 0;
        while (i < s0.length) {
            if (s0[i] != s1[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initializeScaleTables(int[] newSampleSize) {
        int bitDepth = this.metadata.IHDR_bitDepth;
        if (bitDepth == this.scalingBitDepth && this.equals(newSampleSize, this.sampleSize)) {
            return;
        }
        this.sampleSize = newSampleSize;
        this.scalingBitDepth = bitDepth;
        int maxOutSample = (1 << bitDepth) - 1;
        if (bitDepth <= 8) {
            this.scale = new byte[this.numBands][];
            int b = 0;
            while (b < this.numBands) {
                int maxInSample = (1 << newSampleSize[b]) - 1;
                int halfMaxInSample = maxInSample / 2;
                this.scale[b] = new byte[maxInSample + 1];
                int s = 0;
                while (s <= maxInSample) {
                    this.scale[b][s] = (byte)((s * maxOutSample + halfMaxInSample) / maxInSample);
                    ++s;
                }
                ++b;
            }
            this.scale0 = this.scale[0];
            this.scalel = null;
            this.scaleh = null;
        } else {
            this.scaleh = new byte[this.numBands][];
            this.scalel = new byte[this.numBands][];
            int b = 0;
            while (b < this.numBands) {
                int maxInSample = (1 << newSampleSize[b]) - 1;
                int halfMaxInSample = maxInSample / 2;
                this.scaleh[b] = new byte[maxInSample + 1];
                this.scalel[b] = new byte[maxInSample + 1];
                int s = 0;
                while (s <= maxInSample) {
                    int val = (s * maxOutSample + halfMaxInSample) / maxInSample;
                    this.scaleh[b][s] = (byte)(val >> 8);
                    this.scalel[b][s] = (byte)(val & 0xFF);
                    ++s;
                }
                ++b;
            }
            this.scale = null;
            this.scale0 = null;
        }
    }

    @Override
    public void write(IImageData im, int pixelPerMeterX, int pixelPerMeterY) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (im == null) {
            throw new IllegalArgumentException("image == null!");
        }
        this.sourceXOffset = 0;
        this.sourceYOffset = 0;
        this.sourceWidth = im.getWidthInPixels();
        this.sourceHeight = im.getHeightInPixels();
        this.periodX = 1;
        this.periodY = 1;
        int destWidth = (this.sourceWidth + this.periodX - 1) / this.periodX;
        int destHeight = (this.sourceHeight + this.periodY - 1) / this.periodY;
        if (destWidth <= 0 || destHeight <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
        this.metadata = new PNGMetadata();
        if (pixelPerMeterX > 0 && pixelPerMeterY > 0) {
            this.metadata.pHYs_present = true;
            this.metadata.pHYs_pixelsPerUnitXAxis = pixelPerMeterX;
            this.metadata.pHYs_pixelsPerUnitYAxis = pixelPerMeterY;
            this.metadata.pHYs_unitSpecifier = 1;
        }
        this.numBands = this.metadata.getNumBands(im);
        this.metadata.initialize(im);
        this.metadata.IHDR_width = destWidth;
        this.metadata.IHDR_height = destHeight;
        this.bpp = this.numBands * (this.metadata.IHDR_bitDepth == 16 ? 2 : 1);
        this.initializeScaleTables(this.metadata.getSampleSize(im));
        try {
            this.write_magic();
            this.write_IHDR();
            this.write_cHRM();
            this.write_gAMA();
            this.write_iCCP();
            this.write_sBIT();
            this.write_sRGB();
            this.write_PLTE();
            this.write_hIST();
            this.write_tRNS();
            this.write_bKGD();
            this.write_pHYs();
            this.write_sPLT();
            this.write_tIME();
            this.write_tEXt();
            this.write_iTXt();
            this.write_zTXt();
            this.writeUnknownChunks();
            this.write_IDAT(im);
            this.writeIEND();
        }
        catch (IOException e) {
            throw new IIOException("I/O error writing PNG file!", e);
        }
    }
}

