/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.print;

import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.lib.graphics.print.IPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.IVariablePageSizeDeviceDriver;
import com.arcway.lib.graphics.print.PrintingFailure;

public class VariablePageSizePrinter
implements IPrinter {
    private final IVariablePageSizeDeviceDriver variablePageSizeDeviceDriver;
    private final Rectangle pageSizeInMM;
    private final Rectangle drawingAreaInMM;
    private IDeviceDriver currentDeviceDriver;

    public VariablePageSizePrinter(IVariablePageSizeDeviceDriver variablePageSizeDeviceDriver, IPageDescription pageDescription) {
        this.variablePageSizeDeviceDriver = variablePageSizeDeviceDriver;
        this.pageSizeInMM = new Rectangle(0.0, 0.0, pageDescription.getPageDimension());
        this.drawingAreaInMM = this.pageSizeInMM.shrink(pageDescription.getPrintAreaInsets());
    }

    @Override
    public Rectangle getPageSize() {
        return this.pageSizeInMM;
    }

    @Override
    public Rectangle getDrawingArea() {
        return this.drawingAreaInMM;
    }

    @Override
    public void performJob(String jobName, IPrinter.IPrintingJobProcessor jobProcessor) throws PrintingFailure {
        jobProcessor.processPrintingJob(new IPrinter.IPrintingJob(){

            @Override
            public void drawPage(Rectangle totalDrawingHint, IPrinter.IPagePrinter pagePrinter) throws PrintingFailure {
                Rectangle drawingHint = totalDrawingHint == null ? VariablePageSizePrinter.this.pageSizeInMM : totalDrawingHint;
                Rectangle totalDrawingHintInDriverCoordinates = VariablePageSizePrinter.this.variablePageSizeDeviceDriver.calculateTotalDrawingAreaInDriverCoordinates(drawingHint);
                TransformationAffiliate mmToDriverCoordinates = Transformation.createTransformation(drawingHint, totalDrawingHintInDriverCoordinates);
                Rectangle pageSizeInDriverCoordinates = VariablePageSizePrinter.this.pageSizeInMM == null ? null : VariablePageSizePrinter.this.pageSizeInMM.transform(mmToDriverCoordinates);
                VariablePageSizePrinter.this.currentDeviceDriver = VariablePageSizePrinter.this.variablePageSizeDeviceDriver.startPage(mmToDriverCoordinates, pageSizeInDriverCoordinates);
                Device device = new Device(VariablePageSizePrinter.this.currentDeviceDriver, mmToDriverCoordinates);
                pagePrinter.printPage(device);
                VariablePageSizePrinter.this.variablePageSizeDeviceDriver.endPage(VariablePageSizePrinter.this.currentDeviceDriver);
                VariablePageSizePrinter.this.currentDeviceDriver = null;
            }
        });
    }

    public void dispose() {
    }

    public IVariablePageSizeDeviceDriver getVariablePageSizeDeviceDriver() {
        return this.variablePageSizeDeviceDriver;
    }
}

