/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linestyles;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.linestyles.ILineDrawProcessor;
import com.arcway.lib.graphics.linestyles.ILineStyleFigure;
import com.arcway.lib.graphics.linestyles.LineStyleCommand;

public class LineStyleFigureLine
implements ILineStyleFigure {
    private final double angleComingFrom;
    private final double xComingFrom;
    private final double yComingFrom;
    private final double angleGoingTo;
    private final double xGoingTo;
    private final double yGoingTo;
    private final double angleLine;
    public Point start;
    public Point end;
    protected double x_go;
    protected double y_go;

    public LineStyleFigureLine(double angleComingFrom, double x1, double y1, double x2, double y2, double arcLength, double angleGoingTo) {
        this.end = this.start = new Point(x1, y1);
        this.angleComingFrom = angleComingFrom;
        this.xComingFrom = x1;
        this.yComingFrom = y1;
        this.angleGoingTo = angleGoingTo;
        this.xGoingTo = x2;
        this.yGoingTo = y2;
        this.angleLine = GeoVector.getDifferenceVectorAngle(x1, y1, x2, y2);
        if (arcLength > 1.0E-10) {
            this.x_go = (x2 - x1) / arcLength;
            this.y_go = (y2 - y1) / arcLength;
        } else {
            this.x_go = 0.0;
            this.y_go = 0.0;
        }
    }

    @Override
    public void start_forward(double arcLength) {
        this.start = new Point(this.start.x + this.x_go * arcLength, this.start.y + this.y_go * arcLength);
    }

    @Override
    public void backward(double arcLength) {
        double x_go_arcLength = this.x_go * arcLength;
        double y_go_arcLength = this.y_go * arcLength;
        this.start = new Point(this.start.x - x_go_arcLength, this.start.y - y_go_arcLength);
        this.end = new Point(this.end.x - x_go_arcLength, this.end.y - y_go_arcLength);
    }

    @Override
    public void end_forward(double arcLength) {
        this.end = new Point(this.end.x + this.x_go * arcLength, this.end.y + this.y_go * arcLength);
    }

    private boolean isStart() {
        return Geo.equals(this.start.x, this.xComingFrom) && Geo.equals(this.start.y, this.yComingFrom);
    }

    private boolean isEnd() {
        return Geo.equals(this.end.x, this.xGoingTo) && Geo.equals(this.end.y, this.yGoingTo);
    }

    @Override
    public void draw(LineStyleCommand command, ILineDrawProcessor lineDrawProcessor) {
        command.drawLine(lineDrawProcessor, this.isStart() ? this.angleComingFrom : this.angleLine, new Line(this.start, this.end), this.isEnd() ? this.angleGoingTo : this.angleLine);
    }

    @Override
    public void next() {
        this.start = this.end;
    }
}

