/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linestyles;

import com.arcway.lib.graphics.linestyles.ILineDrawProcessor;
import com.arcway.lib.graphics.linestyles.LineStyle;

public class LineStyleDrawProcessor {
    protected LineStyle lineStyle;
    protected double lineScale;
    protected ILineDrawProcessor lineDrawProcessor;
    protected double pieceProgress;

    public LineStyleDrawProcessor(ILineDrawProcessor lineDrawProcessor, LineStyle lineStyle, double lineScale) {
        this.lineDrawProcessor = lineDrawProcessor;
        this.lineStyle = lineStyle;
        this.lineScale = lineScale;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setPieceProgress(double pieceProgress) {
        this.pieceProgress = pieceProgress;
    }

    public void drawLineAsPoint(double x, double y) {
        this.pieceProgress = this.lineStyle.drawLineAsPoint(this.lineDrawProcessor, x, y, this.lineScale, this.pieceProgress);
    }

    public void drawLineBeginningPart(double angleComingFrom, double x1, double y1, double x2, double y2, double arcLength, double angleGoingTo) {
        this.pieceProgress = this.lineStyle.drawLineBeginningPart(this.lineDrawProcessor, angleComingFrom, x1, y1, x2, y2, arcLength, angleGoingTo, this.lineScale, this.pieceProgress);
    }

    public void drawLineCenterPart(double angleComingFrom, double x1, double y1, double x2, double y2, double arcLength, double angleGoingTo) {
        this.pieceProgress = this.lineStyle.drawLineCenterPart(this.lineDrawProcessor, angleComingFrom, x1, y1, x2, y2, arcLength, angleGoingTo, this.lineScale, this.pieceProgress);
    }

    public void drawLineEndPart(double angleComingFrom, double x1, double y1, double x2, double y2, double arcLength, double angleGoingTo) {
        this.pieceProgress = this.lineStyle.drawLineEndPart(this.lineDrawProcessor, angleComingFrom, x1, y1, x2, y2, arcLength, angleGoingTo, this.lineScale, this.pieceProgress);
    }

    public void drawArcBeginningPart(double x, double y, double rx, double ry, double angleComingFrom, double a1, double a2, double arcLength, double angleGoingTo) {
        this.pieceProgress = this.lineStyle.drawArcBeginningPart(this.lineDrawProcessor, x, y, rx, ry, angleComingFrom, a1, a2, arcLength, angleGoingTo, this.lineScale, this.pieceProgress);
    }

    public void drawArcCenterPart(double x, double y, double rx, double ry, double angleComingFrom, double a1, double a2, double arcLength, double angleGoingTo) {
        this.pieceProgress = this.lineStyle.drawArcCenterPart(this.lineDrawProcessor, x, y, rx, ry, angleComingFrom, a1, a2, arcLength, angleGoingTo, this.lineScale, this.pieceProgress);
    }

    public void drawArcEndPart(double x, double y, double rx, double ry, double angleComingFrom, double a1, double a2, double arcLength, double angleGoingTo) {
        this.pieceProgress = this.lineStyle.drawArcEndPart(this.lineDrawProcessor, x, y, rx, ry, angleComingFrom, a1, a2, arcLength, angleGoingTo, this.lineScale, this.pieceProgress);
    }
}

