/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linestyles;

import com.arcway.lib.graphics.linestyles.ILineDrawProcessor;
import com.arcway.lib.graphics.linestyles.ILineStyleFigure;
import com.arcway.lib.graphics.linestyles.LineStyleCommand;
import com.arcway.lib.graphics.linestyles.LineStyleCommandDraw;
import com.arcway.lib.graphics.linestyles.LineStyleCommandDrawThrough;
import com.arcway.lib.graphics.linestyles.LineStyleCommandPlot;
import com.arcway.lib.graphics.linestyles.LineStyleCommandSkip;
import com.arcway.lib.graphics.linestyles.LineStyleCommandSkipThrough;
import com.arcway.lib.graphics.linestyles.LineStyleFigureArc;
import com.arcway.lib.graphics.linestyles.LineStyleFigureLine;
import com.arcway.lib.graphics.linestyles.LineStyleFigurePoint;
import java.util.ArrayList;
import java.util.Iterator;

public class LineStyle {
    public static ArrayList<LineStyle> lineStylesDefault = new ArrayList();
    public static final LineStyle NONE = new LineStyle();
    public static final LineStyle SOLID;
    public static final LineStyle DASH;
    public static final LineStyle DOT;
    public static final LineStyle DASHDASHDOT;
    public static final LineStyle DASHSHORT;
    public static final LineStyle DASHDOT;
    public static final LineStyle DASHDOTDOT;
    public static final LineStyle DASHDASH;
    public static final LineStyle DOUBLESTROKE;
    public static final LineStyle TRIPLESTROKE;
    public static final LineStyle DOUBLESTROKEDASH;
    public static final LineStyle DOUBLESTROKEDASHSHORT;
    private static final int DONT_REPEAT = 0;
    private static final int REPEAT = 1;
    private static final double NOT_YET_CALCULATED = -1.0;
    private final ArrayList pieceBegin = new ArrayList();
    private final ArrayList pieceCenter = new ArrayList();
    private final ArrayList pieceEnd = new ArrayList();
    private String styleName = "unknown";
    private double pieceBeginArcLengthCached = -1.0;
    private double pieceCenterArcLengthCached = -1.0;
    private double pieceEndArcLengthCached = -1.0;
    private double widthFactor = -1.0;
    private double eraseWidth = -1.0;

    static {
        NONE.setName("none");
        NONE.pieceCenterAdd(new LineStyleCommandSkipThrough());
        lineStylesDefault.add(NONE);
        SOLID = new LineStyle();
        SOLID.setName("Solid");
        SOLID.pieceCenterAdd(new LineStyleCommandDrawThrough());
        lineStylesDefault.add(SOLID);
        DASH = new LineStyle();
        double SCALE = 3.0;
        DASH.setName("Dash");
        DASH.pieceBeginAdd(new LineStyleCommandDraw(9.0));
        DASH.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASH.pieceCenterAdd(new LineStyleCommandDraw(9.0));
        DASH.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASH.pieceEndAdd(new LineStyleCommandDraw(9.0));
        lineStylesDefault.add(DASH);
        DOT = new LineStyle();
        SCALE = 2.0;
        DOT.setName("Dot");
        DOT.pieceBeginAdd(new LineStyleCommandPlot());
        DOT.pieceBeginAdd(new LineStyleCommandSkip(3.0));
        DOT.pieceCenterAdd(new LineStyleCommandPlot());
        DOT.pieceCenterAdd(new LineStyleCommandSkip(3.0));
        DOT.pieceCenterAdd(new LineStyleCommandPlot());
        lineStylesDefault.add(DOT);
        DASHDASHDOT = new LineStyle();
        SCALE = 3.0;
        DASHDASHDOT.setName("DashDashDot");
        DASHDASHDOT.pieceBeginAdd(new LineStyleCommandDraw(9.0));
        DASHDASHDOT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHDASHDOT.pieceBeginAdd(new LineStyleCommandDraw(9.0));
        DASHDASHDOT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHDASHDOT.pieceBeginAdd(new LineStyleCommandPlot());
        DASHDASHDOT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHDASHDOT.pieceCenterAdd(new LineStyleCommandDraw(9.0));
        DASHDASHDOT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHDASHDOT.pieceCenterAdd(new LineStyleCommandDraw(9.0));
        DASHDASHDOT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHDASHDOT.pieceCenterAdd(new LineStyleCommandPlot());
        DASHDASHDOT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHDASHDOT.pieceEndAdd(new LineStyleCommandDraw(9.0));
        DASHDASHDOT.pieceEndAdd(new LineStyleCommandSkip(4.5));
        DASHDASHDOT.pieceEndAdd(new LineStyleCommandDraw(9.0));
        lineStylesDefault.add(DASHDASHDOT);
        DASHSHORT = new LineStyle();
        SCALE = 3.0;
        DASHSHORT.setName("DashShort");
        DASHSHORT.pieceBeginAdd(new LineStyleCommandDraw(4.5));
        DASHSHORT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHSHORT.pieceCenterAdd(new LineStyleCommandDraw(4.5));
        DASHSHORT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHSHORT.pieceEndAdd(new LineStyleCommandDraw(4.5));
        lineStylesDefault.add(DASHSHORT);
        DASHDOT = new LineStyle();
        SCALE = 3.0;
        DASHDOT.setName("DashDot");
        DASHDOT.pieceBeginAdd(new LineStyleCommandDraw(4.5));
        DASHDOT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHDOT.pieceBeginAdd(new LineStyleCommandPlot());
        DASHDOT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHDOT.pieceCenterAdd(new LineStyleCommandDraw(4.5));
        DASHDOT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHDOT.pieceCenterAdd(new LineStyleCommandPlot());
        DASHDOT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHDOT.pieceEndAdd(new LineStyleCommandDraw(4.5));
        lineStylesDefault.add(DASHDOT);
        DASHDOTDOT = new LineStyle();
        SCALE = 3.0;
        DASHDOTDOT.setName("DashDotDot");
        DASHDOTDOT.pieceBeginAdd(new LineStyleCommandDraw(4.5));
        DASHDOTDOT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHDOTDOT.pieceBeginAdd(new LineStyleCommandPlot());
        DASHDOTDOT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHDOTDOT.pieceBeginAdd(new LineStyleCommandPlot());
        DASHDOTDOT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHDOTDOT.pieceCenterAdd(new LineStyleCommandDraw(4.5));
        DASHDOTDOT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHDOTDOT.pieceCenterAdd(new LineStyleCommandPlot());
        DASHDOTDOT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHDOTDOT.pieceCenterAdd(new LineStyleCommandPlot());
        DASHDOTDOT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHDOTDOT.pieceEndAdd(new LineStyleCommandDraw(4.5));
        lineStylesDefault.add(DASHDOTDOT);
        DASHDASH = new LineStyle();
        SCALE = 3.0;
        DASHDASH.setName("DashDash");
        DASHDASH.pieceBeginAdd(new LineStyleCommandDraw(4.5));
        DASHDASH.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DASHDASH.pieceBeginAdd(new LineStyleCommandDraw(9.0));
        DASHDASH.pieceBeginAdd(new LineStyleCommandDraw(4.5));
        DASHDASH.pieceCenterAdd(new LineStyleCommandDraw(4.5));
        DASHDASH.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DASHDASH.pieceCenterAdd(new LineStyleCommandDraw(9.0));
        DASHDASH.pieceCenterAdd(new LineStyleCommandDraw(4.5));
        DASHDASH.pieceEndAdd(new LineStyleCommandDraw(4.5));
        lineStylesDefault.add(DASHDASH);
        DOUBLESTROKE = new LineStyle();
        DOUBLESTROKE.setName("DoubleStroke");
        DOUBLESTROKE.pieceCenterAdd(new LineStyleCommandDrawThrough(2, 2.0));
        lineStylesDefault.add(DOUBLESTROKE);
        TRIPLESTROKE = new LineStyle();
        TRIPLESTROKE.setName("TripleStroke");
        TRIPLESTROKE.pieceCenterAdd(new LineStyleCommandDrawThrough(3, 2.0));
        lineStylesDefault.add(TRIPLESTROKE);
        DOUBLESTROKEDASH = new LineStyle();
        SCALE = 3.0;
        DOUBLESTROKEDASH.setName("DoubleStrokeDash");
        DOUBLESTROKEDASH.pieceBeginAdd(new LineStyleCommandDraw(9.0, 2, 2.0));
        DOUBLESTROKEDASH.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DOUBLESTROKEDASH.pieceCenterAdd(new LineStyleCommandDraw(9.0, 2, 2.0));
        DOUBLESTROKEDASH.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DOUBLESTROKEDASH.pieceEndAdd(new LineStyleCommandDraw(9.0, 2, 2.0));
        lineStylesDefault.add(DOUBLESTROKEDASH);
        DOUBLESTROKEDASHSHORT = new LineStyle();
        SCALE = 3.0;
        DOUBLESTROKEDASHSHORT.setName("DoubleStrokeDashShort");
        DOUBLESTROKEDASHSHORT.pieceBeginAdd(new LineStyleCommandDraw(4.5, 2, 2.0));
        DOUBLESTROKEDASHSHORT.pieceBeginAdd(new LineStyleCommandSkip(4.5));
        DOUBLESTROKEDASHSHORT.pieceCenterAdd(new LineStyleCommandDraw(4.5, 2, 2.0));
        DOUBLESTROKEDASHSHORT.pieceCenterAdd(new LineStyleCommandSkip(4.5));
        DOUBLESTROKEDASHSHORT.pieceEndAdd(new LineStyleCommandDraw(4.5, 2, 2.0));
        lineStylesDefault.add(DOUBLESTROKEDASHSHORT);
    }

    public static LineStyle lineStyleDefaultGetByName(String lineStyleName) {
        for (LineStyle lineStyle : lineStylesDefault) {
            if (!lineStyle.getName().equals(lineStyleName)) continue;
            return lineStyle;
        }
        return null;
    }

    private void pieceBeginAdd(LineStyleCommand command) {
        this.pieceBegin.add(command);
    }

    private void pieceCenterAdd(LineStyleCommand command) {
        this.pieceCenter.add(command);
    }

    private void pieceEndAdd(LineStyleCommand command) {
        this.pieceEnd.add(command);
    }

    private void setName(String styleName) {
        this.styleName = styleName;
    }

    public String getName() {
        return this.styleName;
    }

    public double getEraseWidth() {
        if (this.eraseWidth == -1.0) {
            this.eraseWidth = this.getMaximumEraseWidth(this.pieceBegin);
            this.eraseWidth = Math.max(this.eraseWidth, this.getMaximumEraseWidth(this.pieceCenter));
            this.eraseWidth = Math.max(this.eraseWidth, this.getMaximumEraseWidth(this.pieceEnd));
        }
        return this.eraseWidth;
    }

    private double getMaximumEraseWidth(ArrayList piece) {
        double maxWidthFactor = 0.0;
        Iterator i = piece.iterator();
        while (i.hasNext()) {
            maxWidthFactor = Math.max(maxWidthFactor, ((LineStyleCommand)i.next()).getEraseWidth());
        }
        return maxWidthFactor;
    }

    public double getWidthFactor() {
        if (this.widthFactor == -1.0) {
            this.widthFactor = this.getMaximumWidthFactor(this.pieceBegin);
            this.widthFactor = Math.max(this.widthFactor, this.getMaximumWidthFactor(this.pieceCenter));
            this.widthFactor = Math.max(this.widthFactor, this.getMaximumWidthFactor(this.pieceEnd));
        }
        return this.widthFactor;
    }

    private double getMaximumWidthFactor(ArrayList piece) {
        double maxWidthFactor = 0.0;
        Iterator i = piece.iterator();
        while (i.hasNext()) {
            maxWidthFactor = Math.max(maxWidthFactor, ((LineStyleCommand)i.next()).getWidthFactor());
        }
        return maxWidthFactor;
    }

    protected double pieceArcLengthBegin() {
        if (this.pieceBeginArcLengthCached == -1.0) {
            this.pieceBeginArcLengthCached = this.calculateArcLength(this.pieceBegin);
        }
        return this.pieceBeginArcLengthCached;
    }

    protected double pieceArcLengthCenter() {
        if (this.pieceCenterArcLengthCached == -1.0) {
            this.pieceCenterArcLengthCached = this.calculateArcLength(this.pieceCenter);
        }
        return this.pieceCenterArcLengthCached;
    }

    protected double pieceArcLengthEnd() {
        if (this.pieceEndArcLengthCached == -1.0) {
            this.pieceEndArcLengthCached = this.calculateArcLength(this.pieceEnd);
        }
        return this.pieceEndArcLengthCached;
    }

    private double calculateArcLength(ArrayList piece) {
        double arcLengthSum = 0.0;
        Iterator i = piece.iterator();
        while (i.hasNext()) {
            arcLengthSum += ((LineStyleCommand)i.next()).getArcLength(0.0);
        }
        return arcLengthSum;
    }

    protected double drawLineAsPoint(ILineDrawProcessor lineDrawProcessor, double x, double y, double lineScale, double pieceProgress) {
        return this.drawPointPieces(lineDrawProcessor, x, y, lineScale, pieceProgress, this.pieceCenter, this.pieceArcLengthCenter(), 1);
    }

    private double drawPointPieces(ILineDrawProcessor lineDrawProcessor, double x, double y, double lineScale, double pieceProgress, ArrayList piece, double pieceArcLengthUnscaled, int repeat) {
        LineStyleFigurePoint lineStyleFigureLine = new LineStyleFigurePoint(x, y);
        return this.draw(lineDrawProcessor, lineStyleFigureLine, 0.0, lineScale, pieceProgress, piece, pieceArcLengthUnscaled, repeat);
    }

    protected double drawLineBeginningPart(ILineDrawProcessor lineDrawProcessor, double angleComingFrom, double x1, double y1, double x2, double y2, double arcLength, double angleGoingTo, double lineScale, double pieceProgress) {
        return this.drawLinePieces(lineDrawProcessor, angleComingFrom, x1, y1, x2, y2, arcLength, angleGoingTo, lineScale, pieceProgress, this.pieceBegin, this.pieceArcLengthBegin(), 0);
    }

    protected double drawLineCenterPart(ILineDrawProcessor lineDrawProcessor, double angleComingFrom, double x1, double y1, double x2, double y2, double arcLength, double angleGoingTo, double lineScale, double pieceProgress) {
        return this.drawLinePieces(lineDrawProcessor, angleComingFrom, x1, y1, x2, y2, arcLength, angleGoingTo, lineScale, pieceProgress, this.pieceCenter, this.pieceArcLengthCenter(), 1);
    }

    protected double drawLineEndPart(ILineDrawProcessor lineDrawProcessor, double angleComingFrom, double x1, double y1, double x2, double y2, double arcLength, double angleGoingTo, double lineScale, double pieceProgress) {
        return this.drawLinePieces(lineDrawProcessor, angleComingFrom, x1, y1, x2, y2, arcLength, angleGoingTo, lineScale, pieceProgress, this.pieceEnd, this.pieceArcLengthEnd(), 0);
    }

    private double drawLinePieces(ILineDrawProcessor lineDrawProcessor, double angleComingFrom, double x1, double y1, double x2, double y2, double arcLength, double angleGoingTo, double lineScale, double pieceProgress, ArrayList piece, double pieceArcLengthUnscaled, int repeat) {
        LineStyleFigureLine lineStyleFigureLine = new LineStyleFigureLine(angleComingFrom, x1, y1, x2, y2, arcLength, angleGoingTo);
        return this.draw(lineDrawProcessor, lineStyleFigureLine, arcLength, lineScale, pieceProgress, piece, pieceArcLengthUnscaled, repeat);
    }

    protected double drawArcBeginningPart(ILineDrawProcessor lineDrawProcessor, double x, double y, double rx, double ry, double angleComingFrom, double a1, double a2, double arcLength, double angleGoingTo, double lineScale, double pieceProgress) {
        return this.drawArcPieces(lineDrawProcessor, x, y, rx, ry, angleComingFrom, a1, a2, arcLength, angleGoingTo, lineScale, pieceProgress, this.pieceBegin, this.pieceArcLengthBegin(), 0);
    }

    protected double drawArcCenterPart(ILineDrawProcessor lineDrawProcessor, double x, double y, double rx, double ry, double angleComingFrom, double a1, double a2, double arcLength, double angleGoingTo, double lineScale, double pieceProgress) {
        return this.drawArcPieces(lineDrawProcessor, x, y, rx, ry, angleComingFrom, a1, a2, arcLength, angleGoingTo, lineScale, pieceProgress, this.pieceCenter, this.pieceArcLengthCenter(), 1);
    }

    protected double drawArcEndPart(ILineDrawProcessor lineDrawProcessor, double x, double y, double rx, double ry, double angleComingFrom, double a1, double a2, double arcLength, double angleGoingTo, double lineScale, double pieceProgress) {
        return this.drawArcPieces(lineDrawProcessor, x, y, rx, ry, angleComingFrom, a1, a2, arcLength, angleGoingTo, lineScale, pieceProgress, this.pieceEnd, this.pieceArcLengthEnd(), 0);
    }

    private double drawArcPieces(ILineDrawProcessor lineDrawProcessor, double x, double y, double rx, double ry, double angleComingFrom, double a1, double a2, double arcLength, double angleGoingTo, double lineScale, double pieceProgress, ArrayList piece, double pieceArcLengthUnscaled, int repeat) {
        LineStyleFigureArc lineStyleFigureArc = new LineStyleFigureArc(x, y, rx, ry, angleComingFrom, a1, a2, arcLength, angleGoingTo);
        return this.draw(lineDrawProcessor, lineStyleFigureArc, arcLength, lineScale, pieceProgress, piece, pieceArcLengthUnscaled, repeat);
    }

    private double draw(ILineDrawProcessor lineDrawProcessor, ILineStyleFigure lineStyleFigure, double arcLength, double lineScale, double pieceProgress, ArrayList piece, double pieceArcLengthUnscaled, int repeat) {
        double pieceProgressTemp = pieceProgress;
        double pieceArcLength = pieceArcLengthUnscaled * lineScale;
        double arcLengthSkip = pieceProgressTemp * pieceArcLength;
        double arcLengthTodo = arcLengthSkip + arcLength;
        lineStyleFigure.backward(arcLengthSkip);
        int i = 0;
        boolean firstPiece = true;
        boolean line_finished = false;
        while (!line_finished) {
            double arcLengthCurrent = 0.0;
            if (i < piece.size()) {
                LineStyleCommand command = (LineStyleCommand)piece.get(i);
                arcLengthCurrent = command.getArcLength(arcLengthTodo / lineScale) * lineScale;
                if (arcLengthCurrent + 1.0E-10 > arcLengthTodo) {
                    arcLengthCurrent = arcLengthTodo;
                    line_finished = true;
                }
                lineStyleFigure.end_forward(arcLengthCurrent);
                if (!firstPiece || arcLengthTodo < arcLength + 1.0E-10) {
                    lineStyleFigure.draw(command, lineDrawProcessor);
                } else if (arcLengthTodo - arcLengthCurrent < arcLength + 1.0E-10) {
                    lineStyleFigure.start_forward(arcLengthTodo - arcLength);
                    lineStyleFigure.draw(command, lineDrawProcessor);
                }
            } else {
                line_finished = true;
            }
            lineStyleFigure.next();
            arcLengthTodo -= arcLengthCurrent;
            if (++i < piece.size()) continue;
            i = 0;
            firstPiece = false;
            boolean bl = line_finished = line_finished || repeat == 0;
        }
        if (Math.abs(pieceArcLength) > 1.0E-10) {
            pieceProgressTemp += arcLength % pieceArcLength / pieceArcLength;
            if (Math.abs((pieceProgressTemp %= 1.0) - 1.0) < 1.0E-10) {
                pieceProgressTemp = 0.0;
            }
        }
        return pieceProgressTemp;
    }
}

