/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linestyles;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.graphics.linestyles.LinePieceProcessorFigure;
import com.arcway.lib.graphics.linestyles.LineStyleDrawProcessor;

public class LinePieceProcessorFigureLine
extends LinePieceProcessorFigure {
    double angleComingFrom;
    double angleGoingTo;
    double x1;
    double y1;
    double x2;
    double y2;
    double dx1;
    double dy1;
    double dx2;
    double dy2;

    public LinePieceProcessorFigureLine(LineStyleDrawProcessor lineDrawProcessor, double angleComingFrom, double x1, double y1, double x2, double y2, double angleGoingTo) {
        this.lineDrawProcessor = lineDrawProcessor;
        this.angleComingFrom = angleComingFrom;
        this.angleGoingTo = angleGoingTo;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.dx1 = x1;
        this.dy1 = y1;
        this.dx2 = x2;
        this.dy2 = y2;
    }

    @Override
    public double getArcLength() {
        return Geo.arcLengthLine(this.dx1, this.dy1, this.dx2, this.dy2);
    }

    protected double getOriginalArcLength() {
        return Geo.arcLengthLine(this.x1, this.y1, this.x2, this.y2);
    }

    @Override
    public void skipArcLength(double arcLength) {
        double arcLengthCurrent = this.getOriginalArcLength();
        if (Math.abs(arcLengthCurrent) > 1.0E-10) {
            this.dx1 = (this.x2 - this.x1) * arcLength / arcLengthCurrent + this.dx1;
            this.dy1 = (this.y2 - this.y1) * arcLength / arcLengthCurrent + this.dy1;
        }
    }

    @Override
    public void setArcLength(double arcLength) {
        double arcLengthCurrent = this.getOriginalArcLength();
        if (Math.abs(arcLengthCurrent) > 1.0E-10) {
            this.dx2 = (this.x2 - this.x1) * arcLength / arcLengthCurrent + this.dx1;
            this.dy2 = (this.y2 - this.y1) * arcLength / arcLengthCurrent + this.dy1;
        }
    }

    @Override
    public void drawBeginningPart() {
        this.lineDrawProcessor.drawLineBeginningPart(this.angleComingFrom, this.dx1, this.dy1, this.dx2, this.dy2, this.getArcLength(), this.angleGoingTo);
    }

    @Override
    public void drawCenterPart() {
        this.lineDrawProcessor.drawLineCenterPart(this.angleComingFrom, this.dx1, this.dy1, this.dx2, this.dy2, this.getArcLength(), this.angleGoingTo);
    }

    @Override
    public void drawEndPart() {
        this.lineDrawProcessor.drawLineEndPart(this.angleComingFrom, this.dx1, this.dy1, this.dx2, this.dy2, this.getArcLength(), this.angleGoingTo);
    }

    @Override
    public void next() {
        this.dx1 = this.dx2;
        this.dy1 = this.dy2;
        this.dx2 = this.x2;
        this.dy2 = this.y2;
    }
}

