/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linestyles;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.graphics.linestyles.ILineDrawProcessor;
import com.arcway.lib.graphics.linestyles.LinePieceProcessorFigure;
import com.arcway.lib.graphics.linestyles.LinePieceProcessorFigureArc;
import com.arcway.lib.graphics.linestyles.LinePieceProcessorFigureLine;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.graphics.linestyles.LineStyleDrawProcessor;
import com.arcway.lib.java.To;

public class LinePieceProcessor {
    protected LineStyleDrawProcessor lineStyleDrawProcessor;
    protected int piecesBegin;
    protected int piecesCenter;
    protected int piecesEnd;
    protected double arcLengthBeginningPart;
    protected double arcLengthCenterPiece;
    protected double arcLengthCenterPart;
    protected double arcLengthEndPart;
    protected double arcLengthDone;
    protected double arcLengthToSkip;

    public LinePieceProcessor(ILineDrawProcessor lineDrawProcessor, LineStyle lineStyle, double lineScaleWished, double arcLength, double skipAtBeginning, double skipAtEnd, boolean closedDraw) {
        double arcLengthUnscaled;
        double arcLengthSum = Math.max(0.0, arcLength - skipAtBeginning - skipAtEnd);
        this.arcLengthBeginningPart = lineStyle.pieceArcLengthBegin() * lineScaleWished;
        this.arcLengthCenterPiece = lineStyle.pieceArcLengthCenter() * lineScaleWished;
        this.arcLengthEndPart = lineStyle.pieceArcLengthEnd() * lineScaleWished;
        this.piecesBegin = closedDraw ? 0 : 1;
        this.piecesEnd = closedDraw ? 0 : 1;
        if (this.arcLengthCenterPiece < 1.0E-10) {
            this.piecesCenter = closedDraw ? 1 : (this.arcLengthBeginningPart + this.arcLengthEndPart + 1.0E-10 > arcLengthSum ? 0 : 1);
        } else {
            double piecesFloat = closedDraw ? arcLengthSum / this.arcLengthCenterPiece : (arcLengthSum - this.arcLengthBeginningPart - this.arcLengthEndPart) / this.arcLengthCenterPiece;
            int piecesRoundDown = Math.max(0, (int)Math.floor(piecesFloat));
            int piecesRoundUp = Math.max(0, (int)Math.ceil(piecesFloat));
            this.piecesCenter = Math.abs(piecesFloat - To.toDouble((int)piecesRoundDown)) < Math.abs(piecesFloat - To.toDouble((int)piecesRoundUp)) ? piecesRoundDown : piecesRoundUp;
        }
        this.arcLengthBeginningPart = this.piecesBegin > 0 ? this.arcLengthBeginningPart : 0.0;
        this.arcLengthCenterPart = this.arcLengthCenterPiece * (double)this.piecesCenter;
        double d = this.arcLengthEndPart = this.piecesEnd > 0 ? this.arcLengthEndPart : 0.0;
        if (this.piecesCenter > 0 && this.arcLengthCenterPiece < 1.0E-10) {
            arcLengthUnscaled = arcLengthSum;
            this.arcLengthCenterPart = arcLengthSum - this.arcLengthBeginningPart - this.arcLengthEndPart;
        } else {
            arcLengthUnscaled = this.arcLengthBeginningPart + this.arcLengthCenterPart + this.arcLengthEndPart;
        }
        double lineScale = Geo.equals(0.0, arcLengthUnscaled) ? 1.0 : lineScaleWished * (arcLengthSum / arcLengthUnscaled);
        this.arcLengthBeginningPart = this.arcLengthBeginningPart * lineScale / lineScaleWished;
        this.arcLengthCenterPiece = this.arcLengthCenterPiece * lineScale / lineScaleWished;
        this.arcLengthCenterPart = this.arcLengthCenterPart * lineScale / lineScaleWished;
        this.arcLengthEndPart = this.arcLengthEndPart * lineScale / lineScaleWished;
        this.arcLengthDone = 0.0;
        this.arcLengthToSkip = skipAtBeginning;
        this.lineStyleDrawProcessor = new LineStyleDrawProcessor(lineDrawProcessor, lineStyle, lineScale);
        this.lineStyleDrawProcessor.setPieceProgress(0.0);
    }

    public void process_point(double x, double y) {
        this.lineStyleDrawProcessor.drawLineAsPoint(x, y);
    }

    public void process_line(double angleComingFrom, double x1, double y1, double x2, double y2, double angleGoingTo) {
        LinePieceProcessorFigureLine linePieceProcessorFigureLine = new LinePieceProcessorFigureLine(this.lineStyleDrawProcessor, angleComingFrom, x1, y1, x2, y2, angleGoingTo);
        this.process(linePieceProcessorFigureLine);
    }

    public void process_arc(double x, double y, double rx, double ry, double angleComingFrom, double angleStart, double angleEnd, double angleGoingTo) {
        LinePieceProcessorFigureArc linePieceProcessorFigureArc = new LinePieceProcessorFigureArc(this.lineStyleDrawProcessor, x, y, rx, ry, angleComingFrom, angleStart, angleEnd, angleGoingTo);
        this.process(linePieceProcessorFigureArc);
    }

    private void process(LinePieceProcessorFigure linePieceProcessorFigure) {
        double arcLengthTodoOnFigure = linePieceProcessorFigure.getArcLength();
        if (this.arcLengthToSkip - 1.0E-10 > arcLengthTodoOnFigure) {
            this.arcLengthToSkip -= arcLengthTodoOnFigure;
        } else {
            double next;
            if (this.arcLengthToSkip > 1.0E-10) {
                linePieceProcessorFigure.skipArcLength(this.arcLengthToSkip);
                arcLengthTodoOnFigure -= this.arcLengthToSkip;
                this.arcLengthToSkip = 0.0;
            }
            if (this.arcLengthDone + 1.0E-10 < this.arcLengthBeginningPart) {
                next = this.arcLengthBeginningPart - this.arcLengthDone;
                next = Math.min(next, arcLengthTodoOnFigure);
                linePieceProcessorFigure.setArcLength(next);
                linePieceProcessorFigure.drawBeginningPart();
                linePieceProcessorFigure.next();
                this.arcLengthDone += next;
                arcLengthTodoOnFigure -= next;
            }
            if (this.arcLengthDone + 1.0E-10 > this.arcLengthBeginningPart && this.arcLengthDone + 1.0E-10 < this.arcLengthBeginningPart + this.arcLengthCenterPart) {
                next = this.arcLengthBeginningPart + this.arcLengthCenterPart - this.arcLengthDone;
                next = Math.min(next, arcLengthTodoOnFigure);
                linePieceProcessorFigure.setArcLength(next);
                linePieceProcessorFigure.drawCenterPart();
                linePieceProcessorFigure.next();
                this.arcLengthDone += next;
                arcLengthTodoOnFigure -= next;
            }
            if (this.arcLengthDone + 1.0E-10 > this.arcLengthBeginningPart + this.arcLengthCenterPart && this.arcLengthDone + 1.0E-10 < this.arcLengthBeginningPart + this.arcLengthCenterPart + this.arcLengthEndPart) {
                next = this.arcLengthBeginningPart + this.arcLengthCenterPart + this.arcLengthEndPart - this.arcLengthDone;
                next = Math.min(next, arcLengthTodoOnFigure);
                linePieceProcessorFigure.setArcLength(next);
                linePieceProcessorFigure.drawEndPart();
                linePieceProcessorFigure.next();
                this.arcLengthDone += next;
                arcLengthTodoOnFigure -= next;
            }
        }
    }
}

