/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linestyles;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.graphics.linestyles.ILineDrawProcessor;
import com.arcway.lib.graphics.linestyles.LineStyleCommand;

public abstract class AbstractLineStyleCommandDraw
extends LineStyleCommand {
    private final int nrOfStrokes;
    private final double strokeDistance;

    public AbstractLineStyleCommandDraw(int nrOfStrokes, double strokeDistance) {
        this.nrOfStrokes = nrOfStrokes;
        this.strokeDistance = strokeDistance;
    }

    @Override
    public double getEraseWidth() {
        return this.strokeDistance * (double)(this.nrOfStrokes - 1);
    }

    @Override
    public final double getWidthFactor() {
        return this.strokeDistance * (double)(this.nrOfStrokes - 1) + 1.0;
    }

    @Override
    public void drawPoint(ILineDrawProcessor lineDrawProcessor, Point point) {
        double d = this.strokeDistance * lineDrawProcessor.getLineWidth();
        double r = 0.0;
        int i = 0;
        while (i < this.nrOfStrokes) {
            if (Geo.isZero(r)) {
                lineDrawProcessor.plot(point);
            } else {
                Arc arc = new Arc(point, r, r);
                lineDrawProcessor.arc(arc);
            }
            r += d;
            ++i;
        }
    }

    @Override
    public final void drawLine(ILineDrawProcessor lineDrawProcessor, double angleComingFrom, Line line, double angleGoingTo) {
        if (this.nrOfStrokes == 1) {
            lineDrawProcessor.line(line);
        } else {
            GeoVector offsetGoingTo;
            GeoVector offsetComingFrom;
            double d = this.strokeDistance * lineDrawProcessor.getLineWidth();
            int size = this.nrOfStrokes - 1;
            double centerIndex = ((double)this.nrOfStrokes - 1.0) / 2.0;
            Direction directionComingFrom = Direction.valueOf(angleComingFrom);
            GeoVector lineVector = new GeoVector(line.start, line.end);
            Direction directionLine = lineVector.getDirection();
            Direction directionGoingTo = Direction.valueOf(angleGoingTo);
            GeoVector comingFromNormalized = new GeoVector(d, directionComingFrom);
            GeoVector lineNormalized = lineVector.scaleToLength(d);
            GeoVector goingToNormalized = new GeoVector(d, directionGoingTo);
            GeoVector translationComingFrom = comingFromNormalized.turn90();
            GeoVector translationLine = lineNormalized.turn90();
            GeoVector translationGoingTo = goingToNormalized.turn90();
            Point throughPointComingFrom = line.start.movePoint(translationComingFrom);
            Point throughPointLine = line.start.movePoint(translationLine);
            Point throughPointGoingTo = line.end.movePoint(translationGoingTo);
            StraightLine straightLineComingFrom = new StraightLine(throughPointComingFrom, directionComingFrom);
            StraightLine straightLineLine = new StraightLine(throughPointLine, directionLine);
            StraightLine straightLineGoingTo = new StraightLine(throughPointGoingTo, directionGoingTo);
            if (straightLineComingFrom.isParallel(straightLineLine)) {
                offsetComingFrom = translationComingFrom;
            } else {
                Point intersectionPoint = straightLineComingFrom.getInterceptPoint(straightLineLine);
                offsetComingFrom = new GeoVector(line.start, intersectionPoint);
            }
            if (straightLineGoingTo.isParallel(straightLineLine)) {
                offsetGoingTo = translationGoingTo;
            } else {
                Point intersectionPoint = straightLineGoingTo.getInterceptPoint(straightLineLine);
                offsetGoingTo = new GeoVector(line.end, intersectionPoint);
            }
            GeoVector startOffsetComingFrom = offsetComingFrom.scale(-((double)size) / 2.0);
            Point startPointComingFrom = line.start.movePoint(startOffsetComingFrom);
            GeoVector startOffsetGoingTo = offsetGoingTo.scale(-((double)size) / 2.0);
            Point startPointGoingTo = line.end.movePoint(startOffsetGoingTo);
            double offsetXStart = offsetComingFrom.x;
            double offsetYStart = offsetComingFrom.y;
            double xStart = startPointComingFrom.x;
            double yStart = startPointComingFrom.y;
            double offsetXEnd = offsetGoingTo.x;
            double offsetYEnd = offsetGoingTo.y;
            double xEnd = startPointGoingTo.x;
            double yEnd = startPointGoingTo.y;
            double bendingAngleComingFrom = GeoVector.angle(comingFromNormalized, lineNormalized);
            double bendingAngleGoingTo = GeoVector.angle(lineNormalized, goingToNormalized);
            boolean bendingComingFromClockwise = bendingAngleComingFrom < 1.0E-10;
            boolean bendingComingFromCounterClockwise = bendingAngleComingFrom > 1.0E-10;
            boolean bendingGoingToClockwise = bendingAngleGoingTo < 1.0E-10;
            boolean bendingGoingToCounterClockwise = bendingAngleGoingTo > 1.0E-10;
            int i = 0;
            while (i < this.nrOfStrokes) {
                Line lineToDraw;
                if (Geo.equals(i, centerIndex)) {
                    lineToDraw = line;
                } else {
                    double x1 = xStart + offsetXStart * (double)i;
                    double y1 = yStart + offsetYStart * (double)i;
                    double x2 = xEnd + offsetXEnd * (double)i;
                    double y2 = yEnd + offsetYEnd * (double)i;
                    Point p1 = new Point(x1, y1);
                    StraightLine straightLineLineForI = new StraightLine(p1, directionLine);
                    if (bendingComingFromClockwise && (double)i > centerIndex + 1.0E-10 || bendingComingFromCounterClockwise && (double)i < centerIndex - 1.0E-10) {
                        StraightLine straightLineComingFromForI = new StraightLine(p1, directionComingFrom);
                        StraightLine perpendicularComingFrom = straightLineComingFromForI.getPerpendicular(line.start);
                        StraightLine perpendicularComingFromLine = straightLineLineForI.getPerpendicular(line.start);
                        Point bendingPointComingFrom = perpendicularComingFrom.getInterceptPoint(straightLineComingFromForI);
                        Point bendingPointComingFromLine = perpendicularComingFromLine.getInterceptPoint(straightLineLineForI);
                        if (bendingPointComingFrom != null && bendingPointComingFromLine != null) {
                            x1 = bendingPointComingFromLine.x;
                            y1 = bendingPointComingFromLine.y;
                            if (!bendingPointComingFrom.equalsPoint(p1) && !p1.equalsPoint(bendingPointComingFromLine)) {
                                Arc bendingArc = new Arc(bendingPointComingFrom, p1, bendingPointComingFromLine);
                                lineDrawProcessor.arc(bendingArc);
                            }
                        }
                    }
                    if (bendingGoingToClockwise && (double)i > centerIndex + 1.0E-10 || bendingGoingToCounterClockwise && (double)i < centerIndex - 1.0E-10) {
                        StraightLine straightLineGoingToForI = new StraightLine(p1, directionGoingTo);
                        StraightLine perpendicularGoingToLine = straightLineLineForI.getPerpendicular(line.end);
                        StraightLine perpendicularGoingTo = straightLineGoingToForI.getPerpendicular(line.end);
                        Point bendingPointGoingToLine = perpendicularGoingToLine.getInterceptPoint(straightLineLineForI);
                        Point bendingPointGoingTo = perpendicularGoingTo.getInterceptPoint(straightLineGoingToForI);
                        if (bendingPointGoingToLine != null && bendingPointGoingTo != null) {
                            x2 = bendingPointGoingToLine.x;
                            y2 = bendingPointGoingToLine.y;
                        }
                    }
                    lineToDraw = new Line(x1, y1, x2, y2);
                }
                lineDrawProcessor.line(lineToDraw);
                ++i;
            }
        }
    }

    @Override
    public final void drawArc(ILineDrawProcessor lineDrawProcessor, double angleComingFrom, Arc arc, double angleGoingTo) {
        double d = this.strokeDistance * lineDrawProcessor.getLineWidth();
        double size = (double)(this.nrOfStrokes - 1) * d;
        int centerIndex = this.nrOfStrokes % 2 == 0 ? -1 : (this.nrOfStrokes - 1) / 2;
        double rxStart = arc.rx - size / 2.0;
        double ryStart = arc.ry - size / 2.0;
        int i = 0;
        while (i < this.nrOfStrokes) {
            if (i == centerIndex) {
                lineDrawProcessor.arc(arc);
            } else {
                double rx = rxStart + (double)i * d;
                double ry = ryStart + (double)i * d;
                if (rx > 1.0E-10 && ry > 1.0E-10) {
                    Arc arcToDraw = new Arc(arc.center, rx, ry, arc.angleStart, arc.angleEnd);
                    lineDrawProcessor.arc(arcToDraw);
                }
            }
            ++i;
        }
    }
}

