/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linemarkers;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.linemarkers.LineMarkerPolygon;

public class LineMarkerRoundedArc
extends LineMarkerPolygon {
    protected static final double SCALE = 1.5;
    protected static final Point HOTSPOT = new Point(0.8999999999999999, 0.0);
    protected static final Point LINESPOT = new Point(LineMarkerRoundedArc.HOTSPOT.x - 7.949999999999999, 0.0);
    protected static final double ANGLE = 30.0;
    protected static final double LENGTH = 7.5;
    protected static final double ARC_LENGTH_UNSCALED = new GeoVector(Point.ORIGIN, LINESPOT).abs();

    public LineMarkerRoundedArc() {
        this.setName("Rounded Arc");
        double r = ARC_LENGTH_UNSCALED * Math.sin(Math.toRadians(30.0)) / 2.0;
        double a = ARC_LENGTH_UNSCALED * Math.cos(Math.toRadians(30.0));
        GeoVector dir = new GeoVector(-Math.cos(Math.toRadians(30.0)), Math.sin(Math.toRadians(30.0)));
        GeoVector up = GeoVector.add(new GeoVector(HOTSPOT), dir.scale(a + 7.5));
        this.corners = new Corner[]{new Corner(HOTSPOT, r), new Corner(up.x, up.y), new Corner(LINESPOT), new Corner(up.x, -up.y)};
    }

    @Override
    public double arcLength(double lineThickness) {
        return ARC_LENGTH_UNSCALED * lineThickness;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public boolean drawWithOutline() {
        return false;
    }
}

