/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linemarkers;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.graphics.linemarkers.LineMarkerPolygon;

public class LineMarkerRhombus
extends LineMarkerPolygon {
    private static final double SCALE_LENGTH = 15.0;
    private static final double SCALE_HEIGHT = 10.0;

    public LineMarkerRhombus() {
        this.setName("Rhombus");
        double sizeX = 7.5;
        double sizeY = 5.0;
        this.corners = new Corner[]{new Corner(0.0 - sizeX, 0.0 - sizeY, 0.0), new Corner(0.0, 0.0, 0.0), new Corner(0.0 - sizeX, 0.0 + sizeY, 0.0), new Corner(0.0 - 2.0 * sizeX, 0.0, 0.0)};
    }

    @Override
    public double arcLength(double lineThickness) {
        return lineThickness * 15.0;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean drawWithOutline() {
        return true;
    }
}

