/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linemarkers;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linemarkers.LineMarker;

public class LineMarkerDiamond
extends LineMarker {
    public LineMarkerDiamond() {
        this.setName("Diamond");
    }

    @Override
    public double arcLength(double lineThickness) {
        return 0.0;
    }

    @Override
    public void draw(Device device, Point p, Color lineColor, double lineThickness, FillColor fillColor, double angle, double coronaWidth) {
        double size = (lineThickness + coronaWidth) * 4.0;
        Corners corners = new Corners();
        corners.add(new Corner(p.x, p.y - size, 0.0));
        corners.add(new Corner(p.x + size, p.y, 0.0));
        corners.add(new Corner(p.x, p.y + size, 0.0));
        corners.add(new Corner(p.x - size, p.y, 0.0));
        device.polygon(corners, new FillColor(lineColor), FillStyle.SOLID);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean usesFillColor() {
        return false;
    }
}

